#include "random.hpp"

namespace slmotion {
  namespace random {
    static engine_t engine(0);

    void seed(engine_t::result_type seed) {
      engine.seed(seed);
    }

    engine_t& getEngine() {
      return engine;
    }

    uint64_t rand() {
      return engine();
    }

    uint64_t min() {
      return engine.min();
    }

    uint64_t max() {
      return engine.max();
    }

    template <>
    float unifrnd(float a, float b) {
      std::uniform_real_distribution<float> d(a,b);
      return d(getEngine());
    }

    template <>
    double unifrnd(double a, double b) {
      std::uniform_real_distribution<double> d(a,b);
      return d(getEngine());
    }

    template <>
    std::vector<float> unifrnd(float a, float b, size_t N) {
      std::uniform_real_distribution<float> d(a,b);
      return generateRandomVector<float>(N, d);
    }

    template <>
    std::vector<double> unifrnd(double a, double b, size_t N) {
      std::uniform_real_distribution<double> d(a,b);
      return generateRandomVector<double>(N, d);
    }

    template <>
    cv::Mat_<float> unifrnd(float a, float b, int rows, int cols) {
      std::uniform_real_distribution<float> d(a,b);
      return generateRandomMatrix<float>(rows, cols, d);
    }

    template <>
    cv::Mat_<double> unifrnd(double a, double b, int rows, int cols) {
      std::uniform_real_distribution<double> d(a,b);
      return generateRandomMatrix<double>(rows, cols, d);
    }
  }
}
