#ifdef SLMOTION_ENABLE_VIDFILE_SUPPORT
/**
 * This is a very simple utility that can be used to convert video
 * files into the Vid file format used by Athitsos et al.
 */

#include <iostream>
#include <opencv2/opencv.hpp>
#include <VidHeader.h>

int main(int argc, char* argv[]) {
  if (argc < 3) {
    std::cout << "usage: vidconvert <infile.avi/mov/mpg etc.> <outfile.vid>"
              << std::endl;
    return 1;
  }

  cv::VideoCapture vc(argv[1]);
  cv::Mat m;
  std::vector<cv::Mat> frames;
  while (vc.grab()) {
    vc.retrieve(m);
    frames.push_back(m.clone());
  }

  if (frames.size() == 0) {
    std::cout << "No frames read!" << std::endl;
    return 1;
  }

  VidHeader vh(argv[2], NULL, m.cols, m.rows, frames.size());

  for (size_t i = 0; i < frames.size(); ++i) {
    cv::cvtColor(frames[i], m, CV_BGR2RGB);
    assert(vh.pixmap_size == m.rows*m.cols*m.channels() && 
           vh.pixmap_size == 3*m.cols*m.rows);
    assert(m.isContinuous());
    memcpy(vh.pixmap, m.data, vh.pixmap_size);
    if (!vh.writeNextFrameToVideoFile()) {
      std::cout << "Cannot write frame to vid file!" << std::endl;
      return 1;
    }
  }

  return 0;
}
#else
#include <iostream>
int main() {
  std::cout << "This utility requires the programme to be compiled with "
            << "vid file support. Please recompile the programme with the "
            << "aforementioned option enabled, and try again." << std::endl;
  return 0;
}
#endif

