find_binning = function(data,scrap_data,pwm_data,pwm_scrap_data){

 m=(100+ncol(data)-200);
 positions=c(1,11,21,31,41,51,61,71,81,91:m+11,m+21,m+31,m+41,m+51,m+61,m+71,m+81,m+91);
 
 #%Some initialization
 best_accuracy=0;
 best_positions=positions;
 n_test_pos=min(400,round(nrow(data)/3));
 n_test_neg=min(500,round(nrow(scrap_data)/3));
 label_train = rbind(matrix(1,nrow(data)-n_test_pos,1),matrix(0,nrow(scrap_data)-n_test_neg,1));
 label_test = rbind(matrix(1,n_test_pos,1),matrix(0,n_test_neg,1));
  
  
  for (i in 1:(length(positions)-1)){
    current_accuracy=0
    for (k in 1:(length(positions)-1)){
      positions_temp=positions
      positions_temp=positions_temp[-(k+1)]
      results=rep(0,30,1)
      for (z in 1:30){
     #Divide the data to test and train sets inside the cross-validation
       i_test_pos=sample(nrow(data),n_test_pos,replace=FALSE);
       i_train_pos=setdiff(1:nrow(data),i_test_pos);
       i_test_neg=sample(nrow(scrap_data),n_test_neg,replace=FALSE);
       i_train_neg=setdiff(1:nrow(scrap_data),i_test_neg);
  
       data_train=rbind(data[i_train_pos,],scrap_data[i_train_neg,])
     data_test=rbind(data[i_test_pos,],scrap_data[i_test_neg,])
  #  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
      data_train_temp=bin_data_custom(data_train, positions_temp)
      data_test_temp=bin_data_custom(data_test, positions_temp)
      data_train_temp=log2(0.1+data_train_temp)
      data_test_temp=log2(0.1+data_test_temp)
    
      
      pwm_train=c(pwm_data[i_train_pos],pwm_scrap_data[i_train_neg])
      pwm_test =c(pwm_data[i_test_pos],pwm_scrap_data[i_test_neg])


      data_train_temp=data.frame(label=label_train,data=data_train_temp,pwm=pwm_train)
      data_test_temp=data.frame(label=label_test,data=data_test_temp,pwm=pwm_test)
      model = glm(formula = label ~ ., data = data_train_temp, family = "binomial")
      predictions = predict(model, data_test_temp, type = "response", se = T)

      results[z]= auc(label_test,predictions$fit)
    }
      value=mean(results);
      if (value>current_accuracy){
        current_accuracy=value;
        to_be_merged=k+1;
  }
      
    }
   
    positions=positions[-to_be_merged]
    if (current_accuracy>=best_accuracy){
      best_positions=positions;
      best_accuracy=current_accuracy;
    
    }
  }
return(best_positions)
}