predict_bindnase=function(TF,celltype,folder){

  fn_pos=paste(folder,'/',celltype,'.', TF,'.test.positive',sep='')
  fn_neg=paste(folder,'/',celltype,'.',TF,'.test.negative',sep='')
    
    data_test_pos=load_data_whole(fn_pos)
    data_test_neg=load_data_whole(fn_neg)
    label_test <- c(rep(1,dim(data_test_pos)[1]),rep(0,dim(data_test_neg)[1]))
    x=load(paste(TF,'.model',sep=''))
   
    model=get(x[1])
    positions=get(x[2])
    
    
    data_test=bin_data_custom(rbind(data_test_pos,data_test_neg),positions)
    data_test=log2(0.1+data_test);

    pwm_pos=as.matrix(read.table(paste(folder,'/',celltype,'.',TF,'.pwm_scores.test.positive',sep='')))
    pwm_neg=as.matrix(read.table(paste(folder,'/',celltype,'.',TF,'.pwm_scores.test.negative',sep='')))
    pwm_test=c(pwm_pos,pwm_neg)

    data_test=data.frame(label=label_test,data=data_test,pwm=pwm_test)
  predictions = predict(model, data_test, type = "response", se = T)

  accuracy= auc(label_test,predictions$fit)
  return(accuracy[1])
}