function [rhsfn, rhsSfn, djacfn, R] = Cfull_system(F,Y,P)

n = length(Y);
d = length(P);

S = sym('s', [n, d]);

J = sym(zeros(n,n)); % Jacobian matrix, dF/dy
R = sym(zeros(n,d)); % dF/dp

% Compute J
for i = 1:n
    J(:,i) = diff(F,Y(i));
end

% Compute R
for i = 1:d
    R(:,i) = diff(F,P(i));
end


% evaluate rhsfn based on F
temp_funstr = func2str(matlabFunction(F));
index = find(temp_funstr=='[');
temp_funstr = temp_funstr(index:end);
for i = n:-1:1
    temp_funstr = regexprep(temp_funstr,['y',int2str(i)],['y(',int2str(i),')']);
end
for i = d:-1:1
    temp_funstr = regexprep(temp_funstr,['p',int2str(i)],['theta(',int2str(i),')']);
end
eval(['rhsfn = @(t,y,theta)deal(',temp_funstr,',0,[]);']);

%%%%%%%%%%%%%%%%%%%%%

% Compute U
U = J*S + R;

% evaluate rhsSfn based on U
temp_funstr = func2str(matlabFunction(U));
index = find(temp_funstr=='r');
temp_funstr = temp_funstr(index:end);
for i = n:-1:1
    temp_funstr = regexprep(temp_funstr,['y',int2str(i)],['y(',int2str(i),')']);
end
count = n*d + n;
for i = d:-1:1
    for j = n:-1:1 
        temp_funstr = regexprep(temp_funstr,['s',int2str(j),'_',int2str(i)],['S(',int2str(j),',',int2str(i),')']);
        count = count - 1;
    end
end
for i = d:-1:1
    temp_funstr = regexprep(temp_funstr,['p',int2str(i)],['theta(',int2str(i),')']);
end
eval(['rhsSfn = @(t,y,yd,S,theta)deal(',temp_funstr,',0,[]);']);
%%%%%%%%%%%%%%%%%%%%%

temp_funstr = func2str(matlabFunction(R));
index = find(temp_funstr=='r');
temp_funstr = temp_funstr(index:end);
for i = n:-1:1
    temp_funstr = regexprep(temp_funstr,['y',int2str(i)],['y(',int2str(i),')']);
end
for i = d:-1:1
    temp_funstr = regexprep(temp_funstr,['p',int2str(i)],['theta(',int2str(i),')']);
end
eval(['R = @(t,y,theta)',temp_funstr,';'])

%%%%%%%%%%%%%%%%%%%%%
temp_funstr = func2str(matlabFunction(J));
index = find(temp_funstr=='r');
temp_funstr = temp_funstr(index:end);
for i = n:-1:1
    temp_funstr = regexprep(temp_funstr,['y',int2str(i)],['y(',int2str(i),')']);
end
for i = d:-1:1
    temp_funstr = regexprep(temp_funstr,['p',int2str(i)],['theta(',int2str(i),')']);
end
eval(['djacfn = @(t,y,fy,theta)deal(',temp_funstr,',0,[]);'])