function [F, J] = LSQtarget(theta,model,data)

try

alpha = data.alpha; beta  = data.beta; D = data.DATA;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% CVODES initialization
options = CVodeSetOptions('UserData',theta,'JacobianFn',model.djacfn);

t0 = 0;        % init time
tout = data.T; % time points to be evaluated

% initialize the solver
CVodeInit(model.rhsfn, 'BDF', 'Newton', t0, data.y0, options);

% FSA initialization
Ns  = model.d; % # of parameters
yS0 = model.R(0,data.y0,theta); % initial sensitivities, n x d matrix

% user-provided sensitivity RHS
FSAoptions = CVodeSensSetOptions('method','Simultaneous','ErrControl', true);
CVodeSensInit(Ns, model.rhsSfn, yS0, FSAoptions);

% Run solver 
[status, t, y, S] = CVode(tout,'Normal'); % y is n x N_timepoints matrix and S is a n x d x N_timepoints matrix
Y = y';

% Free memory
CVodeFree;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the standard deviation depends on the signal
SIGMA = alpha + beta * abs(Y);

% compute the squared components of likelihood
c2 = 30; % a constant to make the squaring of first term possible
SIGMA(2*log(SIGMA) + c2 < 0) = exp(-c2/2 + 10^-6); % lower bound for variance
L1 = sqrt(2*log(SIGMA) + c2);
L2 = (D - Y) ./ SIGMA;
F  = [L1(:); L2(:)]; % objective function values at theta

if nargout > 1   % Two output arguments
   J = zeros(2*length(D(:)),length(theta)); % initialize the Jacobian of the function evaluated at x
   for k = 1:length(theta)
       SENS = squeeze(S(:,k,:))';
       dL1  = ( beta ./ ( (sqrt(2*log(SIGMA) + c2)) .* SIGMA ) ) .* SENS;
       dL2  = -( 1./SIGMA + beta*(D - Y)./(SIGMA.^2)) .* SENS;
       J(:,k) = [dL1(:); dL2(:)];
   end
end


if(sum(sum(isnan(J)))>0 || sum(sum(isinf(J)))>0 || sum(isinf(F))>0 || sum(isnan(F))>0)
    % nan or inf in the solution
    F = 10^9*ones(2*length(D(:)),1); J = ones(2*length(D(:)),length(theta));
end

catch error
    % ode system could not be solved
    F = 10^9*ones(2*length(D(:)),1); J = ones(2*length(D(:)),length(theta));
end

end