function log_lh = log_likelihood(theta,model,data)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% CVODES initialization
options = CVodeSetOptions('UserData',theta,'JacobianFn',model.djacfn);

t0 = 0;        % init time
tout = data.T; % time points to be evaluated

% initialize the solver
CVodeInit(model.rhsfn, 'BDF', 'Newton', t0, data.y0, options);

% FSA initialization
Ns  = model.d; % # of parameters
yS0 = model.R(0,data.y0,theta); % initial sensitivities, n x d matrix

% user-provided sensitivity RHS
FSAoptions = CVodeSensSetOptions('method','Simultaneous','ErrControl', true);
CVodeSensInit(Ns, model.rhsSfn, yS0, FSAoptions);

% Run solver 
[status, t, y, S] = CVode(tout,'Normal'); % y is n x N_timepoints matrix and S is a n x d x N_timepoints matrix

% Free memory
CVodeFree;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% the response corresponds to the mean of normal distribution
MU = y';

% the standard deviation depends on the signal
SIGMA = data.alpha + data.beta * abs(MU);

% compute log-likelihood
log_lh = sum( log( 1./sqrt(2*pi*SIGMA(:).^2) ) - ((data.DATA(:) - MU(:)).^2) ./ (2*SIGMA(:).^2) );

end