function result = search(network,data,Z_full,free_rows_of_Z,initSubZ,ind,name,N_optim_rounds)

% run name with experiment index 
runname = [name,int2str(ind)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% set parameters for the search

% initialize variables, matrices, etc.
n_x = network.n_x;            % # of latent variables
n_Z = length(free_rows_of_Z); % # of free rows of Z
z   = initSubZ(:)';           % init. state
N   = n_x*n_Z;                % max # of elements to be flipped

bestZ        = zeros(n_Z,n_x,N); % best configuration of Z
bestZ(:,:,1) = initSubZ;         % init. state
bestULPP     = zeros(1,N);       % best unnornalized log. posterior probabilities
best_theta   = [];

% vector of optimal parameters for the current model
theta_opt = zeros(1,network.n_psl + network.n_ps);


i = 1;
while i <= N
    maxULPPindex = 0;
    maxULPP      = -inf;
    for j = 1:length(z)
        % construct Z
        temp = z;
        temp(j) = mod(temp(j)+1,2);
        Z = reshape(temp,n_Z,n_x);
        
        % sadfsd
        Z_full(free_rows_of_Z,:) = Z;
        
        % construc LEM model
        model = construct_LEM(network,Z_full);
        
        % estimate ulpp
        [theta_ML, ULPP] = est_ulpp(model,data,N_optim_rounds);
        
        % keep track of the best model of this round
        if ULPP > maxULPP
            maxULPPindex = j;
            maxULPP = ULPP;
            theta_opt = theta_ML;
            opt_mod_dim = model.d;
        end
    end
    
    % flip the element that minimizes the target
    z(maxULPPindex) = mod(z(maxULPPindex)+1,2);
    
    % check if there is an improvement in the model fit
    if(i > 1 && maxULPP <= bestULPP(i-1))
        display('The best configuration of the matrix Z:');
        result.bestZ(:,:,i-1)
        display(['with unnormalized log. post. prob. ', num2str(bestULPP(i-1)),'.']);
        % stop
        i = N + 1;
    else
        % else update and continue
        bestZ(:,:,i)    = reshape(z,n_Z,n_x);
        bestULPP(i)     = maxULPP;
        best_theta(i,1:opt_mod_dim) = theta_opt;
        % collect and save results
        result.i              = i;
        result.bestZ          = bestZ(:,:,1:i);
        result.bestULPP       = bestULPP(1:i);
        result.best_theta     = best_theta(1:i,:);
        result.N_optim_rounds = N_optim_rounds;
        save(runname,'result');
        % display the current state
        display([int2str(i), ' elements flipped, unnormalized log. post. prob. is ', num2str(bestULPP(i)),'.']);
        display('Current configuration of the matrix Z:');
        result.bestZ(:,:,i)
        % update counter
        i = i + 1;
        display('Continuing...');
    end
end


end