function model = construct_LEM(network,Z)

% find the indices of active mechanisms and specify the model dimension
act_ind_rates  = find(sum(Z,2) ~= 0,size(Z,1));

latentOnOff = sum(Z(network.free_rows_of_Z,:),1) > 0;

if(latentOnOff(1) == 1 && latentOnOff(2) == 0 && latentOnOff(3) == 0)
    act_ind_latent = [1 2];
elseif(latentOnOff(1) == 0 && latentOnOff(2) == 0 && latentOnOff(3) == 1)
    act_ind_latent = [3 4];
else
    act_ind_latent = [1 2 3 4];
end

n = network.n_y;
d = length(act_ind_rates) + length(act_ind_latent);

Y = sym('y', [n, 1]);
P = sym('p', [d, 1]);
Plin = exp(P);

K = [sym(   ones(length(network.targets_b),1)); ...                     % basal
            Y(network.drivers_act); ...                                 % activation
            Y(network.drivers_synact1).*Y(network.drivers_synact2); ... % synergistic activation
            Y(network.drivers_inh).*Y(network.targets_inh); ...         % inhibition
            Y(network.targets_deg)];                                    % degradation
        
Kact = K(act_ind_rates);


if(latentOnOff(1) == 1 && latentOnOff(2) == 0 && latentOnOff(3) == 0)
    syms t;
    X = [(1./(1 + exp(Plin(d-1)*(t - Plin(d))))); ...
         0; ...
         0];
elseif(latentOnOff(1) == 0 && latentOnOff(2) == 0 && latentOnOff(3) == 1)
    syms t;
    X = [0; ...
         0; ...
         1 - (1./(1 + exp(Plin(d-1)*(t - Plin(d)))))];
elseif(latentOnOff(1) == 0 && latentOnOff(2) == 1 && latentOnOff(3) == 0)
    syms t;
    X = [0; ...
         (1./(1 + exp(Plin(d-1)*(t - Plin(d))))) - (1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
         0];
elseif(latentOnOff(1) == 0 && latentOnOff(2) == 1 && latentOnOff(3) == 1)
    syms t;
    X = [0; ...
     (1./(1 + exp(Plin(d-1)*(t - Plin(d))))) - (1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
      1 - (1./(1 + exp(Plin(d-1)*(t - Plin(d)))))];
elseif(latentOnOff(1) == 1 && latentOnOff(2) == 1 && latentOnOff(3) == 0)
    syms t;
    X = [(1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
     (1./(1 + exp(Plin(d-1)*(t - Plin(d))))) - (1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
      0];
elseif(latentOnOff(1) == 1 && latentOnOff(2) == 0 && latentOnOff(3) == 1)
    syms t;
    X = [(1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
      0; ...
      1 - (1./(1 + exp(Plin(d-1)*(t - Plin(d)))))];
else
    syms t;
    X = [(1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
     (1./(1 + exp(Plin(d-1)*(t - Plin(d))))) - (1./(1 + exp(Plin(d-3)*(t - Plin(d-2))))); ...
      1 - (1./(1 + exp(Plin(d-1)*(t - Plin(d)))))];
end

Z = sym(Z);
ZX = sym(ones(size(Z,1),1));

ZX(network.free_rows_of_Z) = Z(network.free_rows_of_Z,:)*X;


% right hand side function for the actual ODE system
F = sym(network.S(:,act_ind_rates)) * ...
        ((Plin(1:(d-length(act_ind_latent))) .* Kact) .* ZX(act_ind_rates));

[rhsfn, rhsSfn, djacfn, R] = Cfull_system(F,Y,P);

model.n       = n;
model.d       = d;
model.rhsfn   = rhsfn;
model.rhsSfn  = rhsSfn;
model.djacfn  = djacfn;
model.R       = R;
model.act_ind_rates  = act_ind_rates;
model.act_ind_latent = act_ind_latent;
model.Z       = Z;