function result = main_test_data(ind)
% Example implementation tested in Matlab R2015b with sundials-2.5.0

dataname = 'simulated_data';
load(dataname);

% Set random seed
rng('default');

% construct the network
network = define_network;

% name
name = ['result_for_',dataname,'_with_',network.network_name];

% Z matrix
free_rows_of_Z = network.free_rows_of_Z;                    % free rows of Z
initSubZ       = zeros(length(free_rows_of_Z),network.n_x); % initial state of free rows
Z_full         = ones(network.n_ps,network.n_x);            % full Z in which the sub Z is substituted

N_optim_rounds = 100;

% run inference
result = search(network,data,Z_full,free_rows_of_Z,initSubZ,ind,name,N_optim_rounds);