function network = define_network

% number of model variables
n_y = 4;

% variable names
names = {'Gene 1','Gene 2','Gene 3','Gene 4'};
network_name = 'test_model';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% basal activation
targets_b = [1 2];
Sb = sparse(targets_b,1:length(targets_b),ones(size(targets_b)),n_y,length(targets_b));

mech_basal = cell(1,length(targets_b));
for i = 1:length(targets_b)
    mech_basal{i} = [' --> ',names{targets_b(i)}];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% activating interactions
drivers_act = [1 2 3 2 3];
targets_act = [2 2 2 3 4];
Sa = sparse(targets_act,1:length(targets_act),ones(size(targets_act)),n_y,length(targets_act));

mech_act = cell(1,length(drivers_act));
for i = 1:length(drivers_act)
    mech_act{i} = [names{drivers_act(i)},' --> ',names{targets_act(i)}];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% synergistic activating interactions
drivers_synact1 = [];
drivers_synact2 = [];
targets_synact  = [];

% Ssyna = sparse(targets_synact,1:length(targets_synact),ones(size(targets_synact)),n_y,length(targets_synact));
% 
% mech_synact = cell(1,length(drivers_synact1));
% for i = 1:length(drivers_synact1)
%     mech_synact{i} = [names{drivers_synact1(i)},' + ',names{drivers_synact2(i)} ,' --> ',names{targets_synact(i)}];
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% inhibitory interactions
drivers_inh = [4];
targets_inh = [3];
Si = sparse(targets_inh,1:length(targets_inh),-ones(size(targets_inh)),n_y,length(targets_inh));

mech_inhib = cell(1,length(drivers_inh));
for i = 1:length(drivers_inh)
    mech_inhib{i} = [names{drivers_inh(i)},' --| ',names{targets_inh(i)}];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% degradation
targets_deg = [1 2 3 4];
Sd = sparse(targets_deg,1:length(targets_deg),-ones(size(targets_deg)),n_y,length(targets_deg));

mech_degra = cell(1,length(targets_deg));
for i = 1:length(targets_deg)
    mech_degra{i} = [names{targets_deg(i)},' --> '];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% full stoichiometry and number of params
S = full([Sb Sa Si Sd]);
n_ps = size(S,2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% names for mechanisms
mech_names = [mech_basal,mech_act,mech_inhib,mech_degra]';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% indices for the mechanisms that can be affected by latent effects
free_rows_of_Z = 3:8;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% latent process
n_x   = 3; % # of latent variables 
n_psl = 4; % # of latent params
syms psl1 psl2 psl3 psl4 t;
X = [(1./(1 + exp(exp(psl1)*(t - exp(psl2))))); ...
     (1./(1 + exp(exp(psl3)*(t - exp(psl4))))) - (1./(1 + exp(exp(psl1)*(t - exp(psl2))))); ...
      1 - (1./(1 + exp(exp(psl3)*(t - exp(psl4)))))];
latent = matlabFunction(X);


%%%%%%%%%%
% output struct

network.latent      = latent;
network.n_y         = n_y;
network.targets_b   = targets_b;
network.drivers_act = drivers_act;
network.targets_act = targets_act;
network.drivers_synact1 = drivers_synact1;
network.drivers_synact2 = drivers_synact2;
network.targets_synact  = targets_synact;
network.drivers_inh = drivers_inh;
network.targets_inh = targets_inh;
network.targets_deg = targets_deg;
network.S           = S;
network.n_ps        = n_ps;
network.n_psl       = n_psl;
network.n_x         = n_x;
network.mech_names  = mech_names;
network.names       = names;
network.network_name   = network_name;
network.free_rows_of_Z = free_rows_of_Z;


end