function result = main_th17_data(ind)
% Example implementation tested in Matlab R2015b with sundials-2.5.0

dataname = 'th17_data';
load(dataname);

% Set random seed
rng('default');

% construct the network
network = define_network_th17;

% name
name = ['result_for_',dataname,'_with_',network.network_name];

% Z matrix
free_rows_of_Z = network.free_rows_of_Z;                    % free rows of Z
initSubZ       = zeros(length(free_rows_of_Z),network.n_x); % initial state of free rows
Z_full         = ones(network.n_ps,network.n_x);            % full Z in which the sub Z is substituted

% # of initial point in multistart optimization
N_optim_rounds = 300;

% run inference
result = search(network,data,Z_full,free_rows_of_Z,initSubZ,ind,name,N_optim_rounds);