function run_post_analysis(n_chains,model_index,n_beta,n_samples,DATA,MODELS,theta_map)

param_indices = MODELS{model_index};

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compute response for map parmas
time_points = linspace(0,80,100);

theta_maplin                = zeros(1,8);
theta_maplin(param_indices) = exp(theta_map);

[~, pa_result.X_mapWT]  = ode15s(@(t,x)rhsf_micenv(t,x,theta_maplin,1),time_points,[DATA.mtot(1,1) 0 0 1 0]);
pa_result.Y_mapWT       = sum(pa_result.X_mapWT(:,1:3),2);
[~, pa_result.X_mapPET] = ode15s(@(t,x)rhsf_micenv(t,x,theta_maplin,0),time_points,[DATA.mtot(1,2) 0 0 1 0]);
pa_result.Y_mapPET      = sum(pa_result.X_mapPET(:,1:3),2);

filename = ['post_analysis_result_m',int2str(model_index)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% combine chains
SAMPLES = zeros(n_beta,length(param_indices),n_chains*n_samples);
LOG_LH  = zeros(n_chains*n_samples,n_beta);
CUR_F   = zeros(n_chains*n_samples,n_beta);

for i = 1:n_chains
    load(['./result_chains/pMCMCresult_m',int2str(model_index),'_c',int2str(i),'.mat']);
    SAMPLES(:,:,1+(i-1)*n_samples:(i*n_samples)) = result.SAMPLES;
    LOG_LH(1+(i-1)*n_samples:(i*n_samples),:)    = result.LOG_LH;
    CUR_F(1+(i-1)*n_samples:(i*n_samples),:)     = result.CUR_F;
end

pa_result.SAMPLES = SAMPLES;
pa_result.LOG_LH  = LOG_LH;
pa_result.CUR_F   = CUR_F;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% estimate the log-marginal likelihood
beta          = pMCMC_params.beta;
Elog_deviance = mean(LOG_LH); % simple MCMC integration, estimate of expected log deviance at each temperature
log_margLH    = sum(0.5 * diff(beta) .* (Elog_deviance(1:(end-1)) + Elog_deviance(2:end))); % trapezoidal rule

pa_result.log_margLH = log_margLH;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% estimate the PPDs
SAMPLES_at_posterior = squeeze(SAMPLES(end,:,:))';

growth_on_ethanol = 1;
[X_meanWT,X_quantilesWT, Y_meanWT, Y_quantilesWT]     = pred_response(MODELS{model_index},SAMPLES_at_posterior,time_points,growth_on_ethanol,DATA);
growth_on_ethanol = 0;
[X_meanPET,X_quantilesPET, Y_meanPET, Y_quantilesPET] = pred_response(MODELS{model_index},SAMPLES_at_posterior,time_points,growth_on_ethanol,DATA);

pa_result.time_points    = time_points;

pa_result.X_meanWT       = X_meanWT;
pa_result.X_quantilesWT  = X_quantilesWT;
pa_result.Y_meanWT       = Y_meanWT;
pa_result.Y_quantilesWT  = Y_quantilesWT;

pa_result.X_meanPET      = X_meanPET;
pa_result.X_quantilesPET = X_quantilesPET;
pa_result.Y_meanPET      = Y_meanPET;
pa_result.Y_quantilesPET = Y_quantilesPET;

save(filename,'pa_result');

end

function [X_mean,X_quantiles, Y_mean, Y_quantiles] = pred_response(theta_ind,post_samples,time_points,growth_on_ethanol,DATA)

RESP_SAMPLES = zeros(length(time_points),5,size(post_samples,1));
DATA_SAMPLES = zeros(length(time_points),size(post_samples,1));

if(growth_on_ethanol == 1)
    STD        = interp1(DATA.time,DATA.std(:,1),time_points)';
    init_state = [DATA.mtot(1,1) 0 0 1 0];
    strain     = 'wild-type';
else
    STD        = interp1(DATA.time,DATA.std(:,2),time_points)';
    init_state = [DATA.mtot(1,2) 0 0 1 0];
    strain     = 'petite';
end

for i = 1:size(post_samples,1)
    theta_lin            = zeros(1,8);
    theta_lin(theta_ind) = exp(post_samples(i,:));
    
    [~, X] = ode15s(@(t,x)rhsf_micenv(t,x,theta_lin,growth_on_ethanol),time_points,init_state);
    RESP_SAMPLES(:,:,i) = X;
    DATA_SAMPLES(:,i)   = sum(X(:,1:3),2) + STD .* randn(size(STD));
    if(mod(i,2500)==0)
        disp(['Estimating PPDs, ',strain,' strain, ', num2str(100* i/size(post_samples,1)), '% finished.']);
    end
end


X_mean      = mean(RESP_SAMPLES,3);
X_quantiles = quantile(RESP_SAMPLES,[0.01 0.5 0.99],3);

Y_mean      = mean(DATA_SAMPLES,2);
Y_quantiles = quantile(DATA_SAMPLES,[0.01 0.5 0.99],2);

end

function dx = rhsf_micenv(t,x,theta,growth_on_ethanol)

dx = zeros(5,1);

dx(1) =   theta(1) * x(1) * x(4) ...
        - theta(2) * (1 / (x(4) + theta(3))) * x(1) ...
        - theta(4) * x(1);

dx(2) =   theta(5) * x(2) * x(5) * growth_on_ethanol ...
        + theta(2) * (1 / (x(4) + theta(3))) * x(1) ...
        - theta(6) * x(2);
    
dx(3) =   theta(4) * x(1) + theta(6) * x(2);

dx(4) = - theta(7) * x(1) * x(4);

dx(5) =   theta(8) * x(1) * x(4)  ...
        - theta(5) * x(2) * x(5) * growth_on_ethanol;
end