function show_post_analysis_result(n_chains,model_index,n_beta,DATA,MODELS)

figure(1);
for i = 1:n_chains
    load(['./result_chains/pMCMCresult_m',int2str(model_index),'_c',int2str(i),'.mat']);
    subplot(2,2,i)
    plot(result.n_accepted_local ./ result.n_local_updates); hold on;
    plot(result.n_accepted_global ./ result.n_global_updates); hold off;
    legend('local','global');
end

load(['post_analysis_result_m',int2str(model_index)]);

param_indices = MODELS{model_index};

color_const = 0.9;

for beta_ind = n_beta
    SAMPLES_at_beta = squeeze(pa_result.SAMPLES(beta_ind,:,:))';
    LOG_LH_at_beta  = pa_result.LOG_LH(:,beta_ind);
    CUR_F_at_beta   = pa_result.CUR_F(:,beta_ind);
    
    for k = 1:size(SAMPLES_at_beta,2)
        figure(2);
        subplot(4,2,param_indices(k))
        plot((SAMPLES_at_beta(:,k)),'.','color',color_const*[1 1 1]);%hold on;
        % use the next line to illustrate target values over the trace
        %scatter(1:length(SAMPLES_at_beta(:,k)),(SAMPLES_at_beta(:,k)),[],CUR_F_at_beta,'.'); %hold on;
        ylabel(['log(\theta_',int2str(MODELS{model_index}(k)),')']);
        if(param_indices(k) > 6)
            xlabel('Sample index')
        end
    end
    figure(3);
    illustrate_pairwise_dependencies((SAMPLES_at_beta),param_indices,LOG_LH_at_beta);
    pause;
end

figure(4);
illustrate_map_response(pa_result.time_points,pa_result.X_mapWT, pa_result.Y_mapWT,DATA.time,DATA.mtot(:,1));
figure(5);
illustrate_map_response(pa_result.time_points,pa_result.X_mapPET, pa_result.Y_mapPET,DATA.time,DATA.mtot(:,2));

figure(6);
illustrate_pred_response(pa_result.time_points,pa_result.X_meanWT,pa_result.X_quantilesWT, pa_result.Y_meanWT, pa_result.Y_quantilesWT,DATA.time,DATA.mtot(:,1));
figure(7);
illustrate_pred_response(pa_result.time_points,pa_result.X_meanPET,pa_result.X_quantilesPET, pa_result.Y_meanPET, pa_result.Y_quantilesPET,DATA.time,DATA.mtot(:,2));

end

function illustrate_pred_response(time_points,X_mean,X_quantiles, Y_mean, Y_quantiles,data_time,data_mtot)

names = {'m^g','m^e','m^q','Glucose','Ethanol'};
for i = 1:5
    X = squeeze(X_quantiles(:,i,:));
    subplot(2,3,i);
    x = time_points;
    mean = X(:,2)';
    meanPlusSTD = X(:,3)';
    meanMinusSTD = X(:,1)';
    fill( [x fliplr(x)],  [meanPlusSTD fliplr(meanMinusSTD)], 'b');hold on;
    alpha(.1);
    plot(x, mean, 'b', 'LineWidth', 2.5);hold on;
    plot(x, meanPlusSTD, 'b', 'LineWidth', 0.1);hold on;
    plot(x, meanMinusSTD, 'b', 'LineWidth', 0.1);hold on;
    plot(x, X_mean(:,i), 'k', 'LineWidth', 2);hold on;
    xlim([0 80]);
    %xticks([0, 80]);
    if(i == 1 || i == 4)
        ylabel('A.u.');
    end
    if(i == 4 || i == 5)
        xlabel('Time (h)');
    end
    
    if(i == 4 || i == 5)
        ylim([0 1]);
        %yticks([0, 1]);
    else
        ylim([0 1.5]);
        %yticks([0, 1.5]);
    end
    title(names{i})
    box off;
end
    X = Y_quantiles;
    subplot(2,3,6);
    x = time_points;
    mean = X(:,2)';
    meanPlusSTD = X(:,3)';
    meanMinusSTD = X(:,1)';
    
    fill( [x fliplr(x)],  [meanPlusSTD fliplr(meanMinusSTD)], 'b');hold on;
    alpha(.1);
    plot(x, mean, 'b', 'LineWidth', 2);hold on;
    plot(x, meanPlusSTD, 'b', 'LineWidth', 1);hold on;
    plot(x, meanMinusSTD, 'b', 'LineWidth', 1);hold on;
    plot(x, Y_mean, 'k', 'LineWidth', 2);hold on;
    plot(data_time,data_mtot,'r', 'LineWidth', 2);hold on;
    xlim([0 80]);
    %xticks([0, 80]);
    ylim([0 2.5]);
    %yticks([0, 2.5]);
    ylabel('Cell density (OD)'); xlabel('Time (h)');
    title('Total cell mass');
    box off;
    
end

function illustrate_map_response(time_points,X_map, Y_map,data_time,data_mtot)

names = {'m^g','m^e','m^q','g','e'};
for i = 1:5
    subplot(2,3,i);
    plot(time_points, X_map(:,i), 'k', 'LineWidth', 2);hold on;
    xlim([0 80]);
    if(i == 4 || i == 5)
        ylim([0 1]);
    else
        ylim([0 2]);
    end
    title(names{i})
    box off;
end
    subplot(2,3,6);
    plot(data_time,data_mtot,'r', 'LineWidth', 3);hold on;
    plot(time_points, Y_map, 'b', 'LineWidth', 2);
    xlim([0 79.5]);
    ylim([0 2.5]);
    title('Data vs. m_{tot}');
    box off;   
end

function illustrate_pairwise_dependencies(SAMPLES,param_ind,LOG_LH)

count = 1;
for i = 1:size(SAMPLES,2)
    for j = 1:size(SAMPLES,2)
        if j == i
            subplot(size(SAMPLES,2),size(SAMPLES,2),count)
            % kernel density est.
            [F,XI]= ksdensity((SAMPLES(:,j)));area(XI,F);
            % or hist0gram
            %hist(SAMPLES(:,j));
            if(i == size(SAMPLES,2))
                xlabel(['log(\theta_',int2str(param_ind(j)),')'])
            end
            if(j == 1 && i > 1)
                ylabel(['log(\theta_',int2str(param_ind(i)),')'])
            end
            box off;
        end
        if j < i
            subplot(size(SAMPLES,2),size(SAMPLES,2),count)
            % illustrate with 3d hist
            %[N C] = hist3([(SAMPLES(:,j)),(SAMPLES(:,i))],[50 50]); imagesc(C{1},C{2},N); set(gca,'YDir','normal')
            % or scatter
            %scatter(SAMPLES(:,j),SAMPLES(:,i),[],LOG_LH,'.')
            % or scatter without color
            %scatter(SAMPLES(:,j),SAMPLES(:,i),'.','color',0.9*[1 1 1]);
            scatter(SAMPLES(:,j),SAMPLES(:,i),1,'MarkerEdgeColor',0.9*[1 1 1],'MarkerFaceColor',0.9*[1 1 1]);%,'LineWidth',1.5);
            if(i == size(SAMPLES,2))
                xlabel(['log(\theta_',int2str(param_ind(j)),')'])
            end
            if(j == 1)
                ylabel(['log(\theta_',int2str(param_ind(i)),')'])
            end
            box off;
        end
        count = count + 1;
    end
end

end