function [y_star, y_star_var, f_star_var] = GPpred(X,y,X_star,theta)

n = size(X,2);
d = length(theta);

% define cov fun
covfun = @(xi,xj,theta)( theta(d-1)^2 * exp( -(1/2) * (xi - xj)' * diag(theta(1:(d-2)).^-2) * (xi - xj)) );

% compute covs...
K = zeros(n);
for i = 1:n
    for j = 1:n
        K(i,j) = covfun(X(:,i),X(:,j),theta);
    end
end

L     = chol(K + theta(d)^2*eye(n),'lower');
alpha = L'\(L\y);

% matrices for predicted means and vars
y_star     = zeros(1,size(X_star,2));
y_star_var = zeros(1,size(X_star,2));
f_star_var = zeros(1,size(X_star,2));
k_star     = zeros(n,1);

% compute predictions
if(~isempty(X_star))
    for i = 1:size(X_star,2)
        for j = 1:n
            k_star(j) = covfun(X_star(:,i),X(:,j),theta);
        end
        y_star(i) =  k_star' * alpha;
        v = L\k_star;
        f_star_var(i) = (covfun(X_star(:,i),X_star(:,i),theta)) - v'*v;
        y_star_var(i) = (covfun(X_star(:,i),X_star(:,i),theta) + theta(d)^2) - v'*v; % note that theta(d)^2 is added here because this is predictive dist. over y
    end
end

end