function [value, x_pred, t_pred] = compute_value(fp_area, dT, L, maxT,data)
% returns the log of sum of squared residuals computed using
% the predicted fpsize in the interval [L maxT];

scaling_constant_pred = 100;

start_ind = round(L/dT);
stop_ind  = round(maxT/dT);

x_pred = fp_area(start_ind:stop_ind)/scaling_constant_pred;
t_pred = L:dT:maxT;
t_pred = t_pred - L;

X = interp1(data.t,data.x,t_pred);

value = log( sum( (x_pred - X).^2 ) );