function illustrate_GPfit(run_name,LB,UB,dp)

% initialize the discrete grid for illustration
d = length(LB);
if(d == 2)
    xgv = LB(1):dp:UB(1);
    ygv = LB(2):dp:UB(2);
    [xxx,yyy] = meshgrid(xgv,ygv);
    X_star = [xxx(:) yyy(:)]';
else
    display('Check dimension.');
    return;
end

load(['bayes_opt_',run_name]);

[f_star_at_meas, ~, ~] = GPpred(X,y,X,theta_opt);
residuals              = f_star_at_meas - y';

[f_star, ~, ~] = GPpred(X,y,X_star,theta_opt);

[yevalmin, yevalmin_index] = min(y_eval);

subplot(131)
plot(y_eval,'-ko'); hold on;
plot([20,20],[5.5,10],'k--'); hold off;
axis([0 length(y_eval) 5.5 10]); box off;
xlabel('Evaluation index')
ylabel('Function value')

% plot the residuals
subplot(132)
hold off;
stem(residuals,'color','k');box off;
ylim([-0.02,0.02])
xlabel('Evaluation index')
ylabel('Residual')

subplot(133)
contour(xxx,yyy,reshape(f_star,length(ygv),length(xgv)) );hold on;
[~, indind] = min((y_eval - mean(y_eval)) / std(y_eval));
plot(X(1,indind),X(2,indind),'ro','markersize',10); hold on;
scatter(X(1,:),X(2,:),35,(y_eval - mean(y_eval)) / std(y_eval),'filled');hold off;%colorbar;
axis([LB(1) UB(1) LB(2) UB(2)]);
xlabel('log(\lambda_{col})')
ylabel('log(\lambda_{agar})')
title(['Minimum (',num2str(yevalmin),') at (',num2str(X(1,yevalmin_index)),',',num2str(X(2,yevalmin_index)),')'])
disp(['l_1 = ',num2str(theta_opt(1)),' l_2 = ',num2str(theta_opt(2)),' \sigma_f = ',num2str(theta_opt(3)),' \sigma_n = ',num2str(theta_opt(4))])