function model = construct_model_1

n = 5; % dimension of the state
d = 8; % dimension of the param. vector

Y = sym('y', [n, 1]); % state variables
P = sym('p', [d, 1]); % parameters

% define right hand side of the ode system
F = [ ...
    P(1)*Y(1)*Y(4) - P(2)*(1 / (Y(4) + P(3)))*Y(1) - P(4)*Y(1);
    P(5)*Y(2)*Y(5) + P(2)*(1 / (Y(4) + P(3)))*Y(1) - P(6)*Y(2);
    P(4)*Y(1) + P(6)*Y(2);
    -P(7)*Y(1)*Y(4);
    P(8)*Y(1)*Y(4) - P(5)*Y(2)*Y(5)];

[rhsfn, rhsSfn, djacfn, R] = construct_input_for_ODE_solver(F,Y,P,n,d);

model.n       = n;
model.d       = d;
model.rhsfn   = rhsfn;
model.rhsSfn  = rhsSfn;
model.djacfn  = djacfn;
model.R       = R;