%% A0_Th0_analytical
% is a function to solve MDEs of Th0 analytically, using Eq. (S2).
% The matrix exponential is carried out by built-in function 'expm'.
% The result is then used in A1_Th0_analytic.

%% parameters
syms theta1 theta2 theta3 theta4 theta5 theta6 theta7 theta8 theta9 theta10 theta11 theta12 theta13 theta14
syms x_int1 x_int2 x_int4
syms t

%% fixed parameters
theta8  = 1;
theta13 = 1;

%% parameters for Th0
theta2 = 0;

theta5 = 0;
theta6 = 0;
theta11 = 0;

%% matrix A and b
A = [[-theta3          0       0       0        0        ];
    [(1+theta2)*theta1 -theta7 theta5  0        theta6   ];
    [0                 theta8  -theta9 0        0        ];
    [0                 0       theta10 -theta12 theta11  ];
    [0                 0       0       theta13  -theta14 ]];

b = [0                 theta4  0       0        0        ].';

%% initial values
x_int = [x_int1 x_int2 0 x_int4 0].';

%% solution
x_star = -inv(A)*b;
x = x_star + expm(A*t) * (x_int - x_star);

%% output, Th0
clc;

diary ('Th0_analytical.txt');

x(1)
x(2)
x(3)
x(4)
x(5)

diary off