%% A2_Th0_solution
% is a function to solve MDEs of Th0, first analytically using A1_Th0_analytic.
% If the analytical solution fails, this function output the numerical solution using A1_Th_numerical.

function x = A2_Th0_solution(time,theta,x_int)
%% 1st, analytical solution

x = A1_Th0_analytic(time,theta,x_int);

%% check result
mRNA = x(:,[2 4]);

if any(~(mRNA(:) >= 0))
    
    % differences on Th0
    theta(2) = 0;
    theta([5,6,11]) = 0;
    
    % 2nd, numerical method
    x = A1_Th_numerical(time,theta,x_int);
    
end

end