%% A3_MDE_output
% is a function to output solutions of both Th0 and Th17, given the initial values from the experimental data.
% The output solutions can be replicate-independent and -dependent.

function x = A3_MDE_output(theta,time,H,k)
%% initial values

% call the initial values from the experimental data
D_STAT3 = [ 28.615    , 37.556    , 37.919   ];
D_RORC  = [ 0.017925  , 0.061242  , 0.024761 ];

% replicate-independent and -dependent initial values
switch H
    case {1,2} % all replicates
        Ag_int      = 40;
        STAT3_m_int = mean(D_STAT3);
        STAT3_p_int = 0;
        RORC_m_int  = mean(D_RORC);
        RORC_p_int  = 0;
    case 3 % each replicates
        Ag_int      = 40;
        STAT3_m_int = D_STAT3(k);
        STAT3_p_int = 0;
        RORC_m_int  = D_RORC(k);
        RORC_p_int  = 0;
end
x_int = [ Ag_int , STAT3_m_int , STAT3_p_int , RORC_m_int , RORC_p_int ];

%% solve MDEs
x.Th0  = A2_Th0_solution(time,theta,x_int); % Eq. (7)
x.Th17 = A1_Th_numerical(time,theta,x_int); % Eq. (8)

end