%% A1_Th_numerical
% is a function to solve MDEs numerically, using Eq. (S2).
% The matrix exponential is carried out by built-in function 'expm'.
% At non-integer time points, matrix exponentials are calculated individually.
% At integer time points, matrix exponentials are first calculated at t=1.

function x = A1_Th_numerical(time,theta,x_int)
%% matrix A and b
A = [[-theta(3)            0         0          0         0          ];
    [(1+theta(2))*theta(1) -theta(7) theta(5)   0         theta(6)   ];
    [0                     theta(8)  -theta(9)  0         0          ];
    [0                     0         theta(10) -theta(12) theta(11)  ];
    [0                     0         0         theta(13)  -theta(14) ]];

b = [0                     theta(4)  0         0          0          ].';

%%
x_star = -inv(A)*b;

%% numerical solution
pts = length(time);
x = zeros(pts,5);

% t = 0
x(1,:) = x_int;

% non integer time points
noninteger_time = find(mod(time(2:end),1))+1; % search
for i = noninteger_time
    x(i,:) = ( x_star + expm(A*time(i)) * (x_int.' - x_star) ).';
end

% integer time points
integer_time = find(~mod(time(2:end),1))+1; % search
expA = expm(A);
for i = integer_time
    x(i,:) = ( x_star + expA^time(i) * (x_int.' - x_star) ).';
end

%% check result
mRNA = x(:,[2 4]);
if any(~(mRNA(:) >= 0))
    % expm at each time point
    for i = integer_time
        x(i,:) = ( x_star + expm(A*time(i)) * (x_int.' - x_star) ).';
    end
end

%% check result, again
if any(~(mRNA(:) >= 0))
    % negative becomes positive
    x(x < 0) = -x(x < 0);
end

end