%% AA3_plot_data
% is a function to plot dynamics of STAT3 and RORC mRNA, with their data points.
% The data points and true responses are represented by circles and solid lines respectively;
% and the dashed lines represent Th17 cell dynamics.
% The controlled and variable groups are represented in black and blue color respectively.

function AA3_plot_data(logtheta,alpha,D,M,H)
%% PLOT - response & data
figure('Name',['dynamics of model (',num2str(M),',',num2str(H),')']); clf;

% STAT3_m & RORC_m
switch H
    case {1,2} % all replicates
        
        % solve ODEs
        time = linspace(0,80,201);
        theta = exp(logtheta);
        x = A3_MDE_output(theta,time,H,[]);
        
        % mRNA
        mRNA_Th0  = [ x.Th0(:,2)  , x.Th0(:,4)  ];          % STAT3_m & RORC_m of Th0
        mRNA_Th17 = [ x.Th17(:,2) , x.Th17(:,4) ];          % STAT3_m & RORC_m of Th17
        x_cont    = mRNA_Th0;                               % STAT3_m & RORC_m - controlled group, Eq. (9)
        x_vari    = (1 - alpha)*mRNA_Th0 + alpha*mRNA_Th17; % STAT3_m & RORC_m - variable group,   Eq. (10) and (11)
        
        % STAT3_m & RORC_m
        for gene = 1:2
            % plot
            subplot(2,1,gene)
            % response
            plot(time,mRNA_Th17(:,gene) , 'b--','LineWidth',1); hold on
            plot(time,x_cont(:,gene) , 'k','LineWidth',3);
            plot(time,x_vari(:,gene) , 'b','LineWidth',3);
            % data
            for k = 1:3
                plot(D.t,D.RPKM_y(1:10     ,gene,k),':ko'); % controlled group data, D^0
                plot(D.t,D.RPKM_y([1,11:19],gene,k),':bx'); % variable group data, D^1
            end
            % settings
            xlabel('time')
            ylabel(D.gene{gene})
            if gene == 1,
                legend('pure Th17 population (x_{Th17})', ...
                    'controlled experimental response (\phi^0)', ...
                    'variable experimental response (\phi^1)', ...
                    'controlled experimental data (D^0)', ...
                    'variable experimental data (D^1)', ...
                    'Location','North');
            end
        end
        
    case 3 % each replicates
        
        % STAT3_m & RORC_m
        for gene = 1:2
            % plot
            subplot(2,1,gene)
            for k = 1:3
                % solve ODEs
                time = linspace(0,80,201);
                theta = exp(logtheta);
                x = A3_MDE_output(theta,time,H,k);
                % mRNA
                mRNA_Th0  = [ x.Th0(:,2)  , x.Th0(:,4)  ];                % STAT3_m & RORC_m of Th0
                mRNA_Th17 = [ x.Th17(:,2) , x.Th17(:,4) ];                % STAT3_m & RORC_m of Th17
                x_cont    = mRNA_Th0;                                     % STAT3_m & RORC_m - controlled group, Eq. (9)
                x_vari    = (1 - alpha(k))*mRNA_Th0 + alpha(k)*mRNA_Th17; % STAT3_m & RORC_m - variable group,   Eq. (12)
                % response
                plot(time,mRNA_Th17(:,gene) , 'b--','LineWidth',1); hold on
                plot(time,x_cont(:,gene) , 'k','LineWidth',3);
                plot(time,x_vari(:,gene) , 'b','LineWidth',3);
                % data
                plot(D.t,D.RPKM_y(1:10     ,gene,k),':ko'); % controlled group data, D^0
                plot(D.t,D.RPKM_y([1,11:19],gene,k),':bx'); % variable group data, D^1
                % settings
                xlabel('time')
                ylabel(D.gene{gene})
                if gene == 1,
                    legend('pure Th17 population (x_{Th17})', ...
                        'controlled experimental response (\phi^0)', ...
                        'variable experimental response (\phi^1)', ...
                        'controlled experimental data (D^0)', ...
                        'variable experimental data (D^1)', ...
                        'Location','North');
                end
            end
        end
end

end