% Script to run simulations

% Set Parameter values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
input_networks = {'group_faithful_dag', 'group_faithful_dag2','group_faithful_dag3'};
input_network_nr = 1; % Possible values: 1, 2, 3
input_network = input_networks{input_network_nr};
p = 1; % Hyperparameter for generating parameters of the network 
seed = 1;
max_fan_in = 3;
nsamples = 1000;

% Set directories
src_directory = '/PATH/TO/DIRECTORY/';
toolbox_directory = '/PATH/TO/DIRECTORY/';
result_directory = '/PATH/TO/DIRECTORY/';
tmp_directory = '/PATH/TO/DIRECTORY/';
gobnilp_directory = '/PATH/TO/DIRECTORY/';



% Set seed
rand('seed', seed);
'Program started'

% Setting paths
addpath([toolbox_directory 'bnt'])
addpath(genpathKPM([toolbox_directory 'bnt']));
addpath(genpath([toolbox_directory 'BNT_StructureLearning_v1.4c']));
addpath([toolbox_directory 'pmtk3-master']);
addpath(genpathPMTK([toolbox_directory 'pmtk3-master']));
addpath(genpath([toolbox_directory 'BDAGL']));
addpath(src_directory);

% Generate filenames
filename = ['group_bn_' input_network '_ns_' num2str(nsamples) '_p_' num2str(p) '_k_' num2str(max_fan_in) '_s_' num2str(seed)];



% Generate data
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
eval(['[bnet, groups] = ' input_network '(' num2str(p) ');']);


N = length(bnet.dag(:, 1));
node_sizes = bnet.node_sizes;
samples = cell(N, nsamples);
for i=1:nsamples
  samples(:,i) = sample_bnet(bnet);
end
data = cell2mat(samples);

% Run comparison
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[ ok ] = group_bn_comparison( data, groups, bnet.node_sizes, my_dag_to_pdag(bnet.dag), filename, toolbox_directory, result_directory, tmp_directory, gobnilp_directory, max_fan_in );

