function [ cond_indep ] = conditional_independence_DAG( dag, groups, setA, setB, setC)
% Decides whether two groups of variables are d-separated in a DAG given a third group.
%
% Returns 1 iff setA and setB are d-separated given setC in
% dag. Groups are given by parameter "groups" (a cell array), and setA, setB, and setC
% are indices in the cell array.

cond_indep = 1;
if isempty(setC)
    cond_set = [];
else
    cond_set = [];
    for i = 1:length(setC)
        cond_set = union(cond_set, groups{setC(i)});
    end
end
for i = groups{setA}
    for j = groups{setB}
        if ~dsep(i, j, cond_set, dag);
            cond_indep = 0;
            return;
        end
    end
end

end

