function [ ok ] = data_to_file( data, arities, filename, type )
% Writes a data matrix data to a file filename in the GOBNILP format. 
% Parameter arities specifies arities of variables 
% type is obsolete and is included for backward compatibility
%
n = length(data(1, :));
m = length(data(:, 1));


node_sizes = [];
for i = 1:n
    node_sizes = [node_sizes, int2str(arities(i)), ' '];
end
node_sizes = node_sizes(1:length(node_sizes) - 1);

fid = fopen(filename, 'w');
fprintf(fid,'%s\n',int2str(n));
fprintf(fid,'%s',node_sizes);
fprintf(fid, '\n');
fprintf(fid,'%s\n',int2str(m));
fclose(fid);
dlmwrite(filename , data - 1 ,'-append', 'delimiter', ' ');

ok = 1;

end

