function [ new_data, new_arities ] = make_group_variables( data, groups, arities )
% Makes group variables by taking Cartesian products of simple variables
%
% Input:
% data		Data matrix of discrete variable
% groups	The grouping
% arities	Arities of the simple variables
%
% Output:
% new_data	Group variables
% new_arities	Arities of the group variables
%

n = length(data(:, 1));
new_data = zeros(n, length(groups));
new_arities = zeros(length(groups), 1);
for i = 1:length(groups)
    group = groups{i};
    coeffs = ones(length(group), 1);
    new_arities(i) = arities(group(1));
    for j = 1:length(group) - 1
        coeffs(j + 1) = coeffs(j)*arities(group(j));
        new_arities(i) = new_arities(i)*arities(group(j + 1));
    end
    for j = 1:n
        new_data(j, i) = sum(data(j, group).*coeffs');
    end
end


end

