function [ d, skeleton_distance, direction_mismatch1, direction_mismatch2] = pdag_hamming_distance( pdag1, pdag2 )
% Computes the structural Hamming distance between two pdags.
%
% Input:
% pdag1, pdag2		PDAGs that are compared
%
% Output:
% d			Structural Hamming distance between PDAGs
% skeleton_distance	Distance between skeletons of the PDAGs. (skeleton = convert all directed edges to undirected)
% direction_mismatch1	Cases where an edge is directed in one PDAG and undirected in the other
% direction_mismatch2	Cases where an edge is directed to opposite directions in the PDAGs
%

    skeleton1 = (abs(pdag1) + abs(pdag1)') > 0;
    skeleton2 = (abs(pdag2) + abs(pdag2)') > 0;
    
    skeleton_mismatches = abs(skeleton1 - skeleton2);
    skeleton_distance = sum(sum(skeleton_mismatches))/2;
    
    direction_mismatch1 = 0; % One arc directed, another not
    direction_mismatch2 = 0; % Both arcs directed but two different directions
    for i = 1:length(pdag1(:, 1)) - 1
        for j = i+1:length(pdag1(:, 1))
            if skeleton_mismatches(i, j) == 0
                if (pdag1(i, j) == 1 && (pdag2(i, j) == -1 || pdag2(j, i) == -1)) || (pdag2(i, j) == 1 && (pdag1(i, j) == -1 || pdag1(j, i) == -1))
                    direction_mismatch1 = direction_mismatch1 + 1;
                elseif (pdag1(i, j) == -1 && pdag2(j, i) == -1) || (pdag2(i, j) == -1 && pdag1(j, i) == -1)
                    direction_mismatch2 = direction_mismatch2 + 1;
                end
            end
        end
    end
    d = skeleton_distance + direction_mismatch1 + direction_mismatch2;                 
    
end

