function [ pdag ] = my_dag_to_pdag( dag )
% Converts a DAG to a PDAG
% Directed arcs are denoted by -1 and undirected by 1.

n = length(dag(:, 1));

cpdag = dag_to_cpdag(dag);
pdag = zeros(n, n);
for i = 1:n-1
    for j = i+1:n
        if cpdag(i, j) == 1 && cpdag(j, i) == 1
            pdag(i, j) = 1;
            pdag(j, i) = 1;
        elseif cpdag(i, j) == 1
            pdag(i, j) = -1;
        elseif cpdag(j, i) == 1
            pdag(j, i) = -1;
        end
    end
end


end

