function [bnet, groups] = group_faithful_dag(p)
% p == 1: parameters from uniform distribution
% p << 1: parameters close to 1 or 0
% p > 1: parameters approach 1/k

N = 30;
dag = zeros(30, 30);
dag([1, 2], 3) = 1;
dag([4, 5], 6) = 1;
dag(2, 7) = 1;
dag(7, 8) = 1;
dag([3, 7], 9) = 1;
dag([3, 6], 10) = 1;
dag([3, 10], 11) = 1;
dag(10, 12) = 1;
dag([8, 11], 13) = 1;
dag([9, 12], 14) = 1;
dag([13, 14], 15) = 1;
dag([15, 20], 19) = 1;
dag(15, 20) = 1;
dag(19, 21) = 1;
dag([14, 18], 22) = 1;
dag([15, 16], 23) = 1;
dag([17, 23], 24) = 1;
dag([20, 22], 25) = 1;
dag(21, 26) = 1;
dag([24, 26], 27) = 1;
dag(22, 28) = 1;
dag([24, 28], 29) = 1;
dag(28, 30) = 1;

groups = {[1, 2, 3], [4, 5, 6], [7, 8, 9], [10, 11, 12], [13, 14, 15], [16, 17, 18], [19, 20, 21], [22, 23, 24], [25, 26, 27], [28, 29, 30]};

discrete_nodes = 1:N;
node_sizes = 2*ones(1,N);
bnet = mk_bnet(dag, node_sizes, 'discrete', discrete_nodes);

for i=1:N
    k = node_sizes(i);
    ps = parents(dag, i);
    psz = prod(node_sizes(ps));
    CPT = dirichletSample(p*ones(1,k), psz);
    bnet.CPD{i} = tabular_CPD(bnet, i, 'CPT', CPT);
end

end
