function [bnet, groups] = group_faithful_dag3(p)
% p == 1: parameters from uniform distribution
% p << 1: parameters close to 1 or 0
% p > 1: parameters approach 1/k

N = 50;
dag = zeros(N, N);
dag(31, 1) = 1;
dag([1, 2], 3) = 1;
dag(42, 4) = 1;
dag(42, 5) = 1;
dag([4, 5], 6) = 1;
dag(2, 7) = 1;
dag([7, 43], 8) = 1;
dag([3, 7], 9) = 1;
dag([3, 6], 10) = 1;
dag([3, 10], 11) = 1;
dag([10,32], 12) = 1;
dag([8, 11], 13) = 1;
dag([9, 12], 14) = 1;
dag([13, 14], 15) = 1;
dag(36, 16) = 1;
dag([15, 20], 19) = 1;
dag([15, 35], 20) = 1;
dag(19, 21) = 1;
dag([14, 18], 22) = 1;
dag([15, 16], 23) = 1;
dag([17, 23], 24) = 1;
dag([20, 22], 25) = 1;
dag(21, 26) = 1;
dag([24, 26], 27) = 1;
dag(22, 28) = 1;
dag([24, 28], 29) = 1;
dag(28, 30) = 1;
dag(31, 33) = 1;
dag([10, 32], 34) = 1;
dag(13, 35) = 1;
dag(46, 36) = 1;
dag([15, 16], 38) = 1;
dag(35, 37) = 1;
dag([25, 26], 39) = 1;
dag([29, 30], 40) = 1;
dag([1, 2], 41) = 1;
dag(33, 43) = 1;
dag([3, 12], 44) = 1;
dag([8, 44], 45) = 1;
dag(45, 47) = 1;
dag([24, 38], 48) = 1;
dag(48, 49) = 1;
dag(30, 50) = 1;

groups = {[1, 2, 3, 31, 41], [4, 5, 6, 32, 42], [7, 8, 9, 33, 43], [10, 11, 12, 34, 44], [13, 14, 15, 35, 45], [16, 17, 18, 36, 46], [19, 20, 21, 37, 47], [22, 23, 24, 38, 48], [25, 26, 27, 39, 49], [28, 29, 30, 40, 50]};

discrete_nodes = 1:N;
node_sizes = 2*ones(1,N);
bnet = mk_bnet(dag, node_sizes, 'discrete', discrete_nodes);

for i=1:N
    k = node_sizes(i);
    ps = parents(dag, i);
    psz = prod(node_sizes(ps));
    CPT = dirichletSample(p*ones(1,k), psz);
    bnet.CPD{i} = tabular_CPD(bnet, i, 'CPT', CPT);
end

end
