function [ scores ] = read_scores( filename, groups )
% Reads a GOBNILP score file and returns a cell array with local scores sorted by which groups the involved variables belong to.
%
% Input:
% filename	Name of the score file
% groups	Grouping
%
% Output:
% scores	
%
    d = dlmread(filename);
    n = d(1, 1);
    g = length(groups);
    scores = cell(n, 2^g);
    ind = 1;
    for i = 1:n
        ind = ind + 1;
        variable = d(ind, 1);
        m = d(ind, 2);
        %c = containers.Map;
        for j = 1:m
            ind = ind + 1;
            k = d(ind, 2);
            parent_set = d(ind, 3:2+k) + 1;
            group_memberships = [];
            p = parent_set;
            ii = 1;
            while ~isempty(p)
                %[p ii]
                c = intersect(p, groups{ii});
                if ~isempty(c)
                    p = setdiff(p, c);
                    group_memberships = [group_memberships ii];
                end
                ii = ii + 1;
            end
            set = indices_to_set(group_memberships);
            %if variable >= g || set >=  2^g
            %    [variable set]
            %    dec2bin(set)
            %end
            if isempty(scores{variable + 1, set + 1})
                scores{variable + 1, set + 1} = [d(ind, 1) indices_to_set(parent_set)];
            else
                scores{variable + 1, set + 1} = [scores{variable + 1, set + 1}; d(ind, 1) indices_to_set(parent_set)];
            end
            
        end
        
    end

end

