function [data_ordered, netw] = netsign_import_data(expressionFile,networkFile,networkGenesFile)

%
% Import Data for NetSign analysis
%

%
% Copyright (C) 2008-2010 Leo Lahti
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%


% Read preprocessed gene expression data. 
A = importdata(expressionFile,'\t');

% Read network matrix
netw = dlmread(networkFile);

% List unique probesets/genes in the network
fid = fopen(networkGenesFile);
networkGenes = textscan(fid,'%s');
fclose(fid);

% Genes in expression data
expression_genes = A.textdata(2:length(A.textdata));      

% Order genes in expression data in the same order as in the network data
% and remove genes that are not in the network
[tf, loc] = ismember(networkGenes{1},expression_genes);
network_genes_expression_indices = loc(loc>0);

expressionGenes = expression_genes(network_genes_expression_indices);

% Transpose to get features on the columns
data_ordered = A.data(network_genes_expression_indices,:)'; 




