/*
  This file is part of NetResponse algorithm. (C) Leo Lahti 2008-2010.

  This file is based on the Agglomerative Independent Variable Group
  Analysis package, Copyright (C) 2001-2007 Esa Alhoniemi, Antti
  Honkela, Krista Lagus, Jeremias Seppa, Harri Valpola, and Paul
  Wagner
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (included in file License.txt in the
  program package) for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include "mex.h"
#include "matrix.h"
 
#define PI 3.1415926535
#define POW2(x) ((x) * (x))



void softmax(int dim1, int dim2, double *in, double *out)
{
  register int i, j;
  double rowsum, rowmax;

  for (i=0; i<dim1; i++) {
    rowmax = DBL_MIN;
    for (j=0; j<dim2; j++) {
      if (in[j*dim1 + i] > rowmax)
	rowmax = in[j*dim1 + i];
    }
    rowsum = 0;
    for (j=0; j<dim2; j++) {
      out[j*dim1 + i] = exp(in[j*dim1 + i] - rowmax);
      rowsum += out[j*dim1 + i];
    }
    for (j=0; j<dim2; j++) {
      out[j*dim1 + i] /= rowsum;
    }
  }
}




/************************************************************/
/* bridge function                                          */

void
mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) {
  int dim1, dim2;
  double *in, *out;
  
  /******************** input variables ********************/

  in      = mxGetPr(prhs[0]);
  dim1    = (int)mxGetM(prhs[0]);
  dim2    = (int)mxGetN(prhs[0]);

  /******************** output variables ********************/

  plhs[0] = mxCreateDoubleMatrix(dim1, dim2, mxREAL);
  out     = mxGetPr(plhs[0]);

  softmax(dim1, dim2, in, out);
  
  return;
}
 
/************************************************************/




