%
% Matlab example 
%

%
% Copyright (C) 2008-2010 Leo Lahti
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2, or (at your option)
% any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% This implementation is based on the Variational Dirichlet Process
% Gaussian Mixture Model implementation, Copyright (C) 2007 Kenichi
% Kurihara (All rights reserved), and AIVGA Agglomerative Independent
% Variable Group Analysis package (v. 1.0) Copyright (C) 2001-2007 Esa
% Alhoniemi, Antti Honkela, Krista Lagus, Jeremias Seppa, Harri
% Valpola, and Paul Wagner For more details on AIVGA, see
% http://www.cis.hut.fi/projects/ivga/



% Specify data files and import data
expressionFile = 'expressions.tab'
networkFile    = 'network.mat';
networkGenesFile = 'network_genes.mat'; % same order as in network data
[D, netw] = netsign_import_data(expressionFile,networkFile,networkGenesFile);

% Compute the model
randseed(32633);
result = netresponse(D, netw)

% Inspect results (the last agglomeration step)
%result.groupings{length(result.groupings)}{1}
