#
# To test a Single Run of variable settings
#
# For questions and bug reports please contact
# suleiman.khan@aalto.fi
#
# Copyright 2013 Suleiman Ali Khan. All rights reserved.
# Citation: Suleiman A. Khan, Samuel Kaski, Bayesian Multi-View Tensor Factorization, ECML 2014.

# Clear the environment
rm(list=ls())

# Load Libraries
require(compiler)
require(tensor)

# Read in the code
source("tools_test.R")
source("bmtf.R")

##
## Generate some data from the model, with pre-specified
## latent components
##
M = 2
N = 30
D = c(40,50)
L = 20
SNR = c(3,2)
CP <- getVisualComponents.3K.Paper(N,N,L,D,M)
tensor.data <- data.train.test.1(CP,SNR)

##
## Run BMTF
##
K <- ncol(tensor.data$Z)
K <- K+1  # The number of components; should be high enough to capture
          # all of the components. This can be recognized by at least a few
          # of the components being shut down


opts <- getDefaultOpts(tensor.data$Y)
model <- bmtf(tensor.data$Y,K,opts)
# Get Posterior Expected Value
model.mean = getPosteriorMean(model)$rs.mean

## Print Relative Contribution of each Component
for(i in 1:K)
	print(rms(remake.tensor(model.mean,i)[[1]]))

## Print Learned View-Component Activity
print("View-Component Activity")
Z = model.mean$Z
colnames(Z) = paste("Comp",1:ncol(Z))
rownames(Z) = paste("View",1:nrow(Z))
print(Z)

