#The below analysis is only for one dataset (namely CghEx), this is actually repeated for different dataset which are stored in "results" folder
load(file.path(res_dir,"topModels.RData"))
stat_table = read.csv(file.path(res_dir,"sigroi_annot_qvals.csv"))

#identify the model
#select the gene_names
#convert to hugo
#save the result

noROI = length(stat_table$ensembl_gene_id)
winds = matrix(0,noROI,10)

library(biomaRt) #annotate sig_roi genes
mart = useMart("ensembl", dataset = "hsapiens_gene_ensembl") #If biomaRt is down change the host to ensembl

for(i in 1:noROI) {
	a = as.vector(stat_table$ensembl_gene_id[i])
	ind = -1+stat_table$chromosome_name[i]*2 #since we have p and q arms
	if(substr(stat_table$band[i],1,1) == "q") {ind = ind +1 } 
k=which(lapply(models[[ind]]@models,function(x) if(!is.na(x)) x@geneName) == a)
	
	winds[i,] = rownames(models[[ind]]@models[[k]]@W$X)

a = getGene(winds[i,],type = "ensembl_gene_id", mart = mart)$hgnc_symbol
winds[i,] = a[1:dim(winds)[2]]
}
rownames(winds) = stat_table$hgnc_symbol
write.csv(winds,file=file.path(res_dir,"roi_genes.csv"))
