nchrom = 22 #No. of chromosomes
windsiz = 10 #Chromosome neighborhood size(in simcca)
TopGen = 10 #No. of genes to select within each chromosome (later use pval)

load(file.path(dat_dir,"preprocessed","data_ensembl.RData"))
load(file.path(res_dir,"permuted_scores.RData"))

data = list()
model = list()
models = list()
genelist = list()
ii = 1

data[[1]] = pexprs
if(length(grep(datapair, "cghexp", ignore.case= TRUE))) {
  data[[2]] = pcgh
  } else if(length(grep(datapair, "mthynexp", ignore.case = TRUE))) {
  data[[2]] = pmthyn
  } else {
  stop("\r Incorrect data selected Check the variable datapair in main.R: Choose either aCGH and GE OR Mehthlation and GE ...") 
  }

data = feat.samp.map(data)	#Map features/samples and scale data


if(!file.exists(res_dir)) dir.create(res_dir)

par(mfrow = c(nchrom,2))
png(file.path(PlotPath,"Dependency_Scores.png"),height=1024,width=2048)
par(mfrow = c(8,5))
op <- options(warn = (-1))
for(i in 1:1) {#nchrom) {# For all chromosomes
	for(j in 1:2) {
		chr_arm = 'p'
		if(j == 2) {chr_arm = 'q'}
		temm = length(which(data[[1]]$info$chr == i & data[[1]]$info$arm == chr_arm))
		if(temm == FALSE | temm < windsiz) {
			model[[ii]] = NA	#If there are no matched samples for an arm
			models[[ii]] = NA
			genelist[[ii]] = NA
		} else {
			models[[ii]] <- screen.cgh.mrna(data[[1]], data[[2]], windowSize = windsiz, chr = i, arm = chr_arm)
			plot(models[[ii]],showTop = TopGen)
			model[[ii]] = topModels(models[[ii]])
			mat = as.data.frame(models[[ii]])
			genelist[[ii]] = mat[sort.list(mat[,2], decreasing = TRUE), ] #sort w.r.t dependency score
		}
		ii = ii + 1
	}
}
options(op) 
dev.off()
Zs = sig.top.models()
save(model, models, genelist, data,Zs, file = file.path(res_dir,"topModels.RData"))

