nchrom = 22 #No. of chromosomes
windsiz = 10 #Chromosome neighborhood size(in simcca)
TopGen = 10 #No. of genes to select within each chromosome (later use pval)

load(file.path(dat_dir,"data_ensembl.RData"))
load(file.path(res_dir,"topModels.RData"))

models = list()
mat = NULL
ii = 0


data[[1]] = pexprs
if(length(grep(datapair, "cghexp", ignore.case= TRUE))) {
  data[[2]] = pcgh
  } else if(length(grep(datapair, "mthynexp", ignore.case = TRUE))) {
  data[[2]] = pmthyn
  } else {
  stop("\r Incorrect data selected Check the variable datapair in main.R: Choose either aCGH and GE OR Mehthlation and GE ...") 
  }

data = feat.samp.map(data)	#Map features/samples and scale data

data[[2]]$data = data[[2]]$data[sample(1:dim(data[[2]]$data)[1]),] #Permute the genes so to destory any correlations
rownames(data[[2]]$data) = rownames(data[[1]]$data)

# Apply CCA in the regular fashion

for(i in 1:nchrom) {# For all chromosomes
        for(j in 1:2) {
                chr_arm = 'p'
                if(j == 2) {chr_arm = 'q'}
                temm = length(which(data[[1]]$info$chr == i & data[[1]]$info$arm == chr_arm))
		if(temm == FALSE | temm < windsiz) { }
		else {                 
			ii = ii + 1
                        models <- screen.cgh.mrna(data[[1]], data[[2]], windowSize = windsiz, chr = i, arm = chr_arm)
                        mat = rbind(mat, as.data.frame(models))
		}
        }
}
perm_mat = mat[sort.list(mat[,2], decreasing = TRUE), ]

save(perm_mat,file = file.path(res_dir,"permuted_scores.RData"))
