summerize.km <- function()
{
proj_dir = path
current_rundir = res_dir

## Read output from KM analysis, annotate significant regions and store the final result
stat_table = read.delim(file.path(current_rundir,"km_anduril_v1","final_camda","km","statistics.csv"))

##annotate sig_roi genes
mart = useMart("ensembl", dataset = "hsapiens_gene_ensembl")

pvals = stat_table$pValue #Pvalues for each ROI based on KM analysis.
sig_roi_index = which(pvals < 0.05) #Significant ROIs
names(sig_roi_index) = colnames(Zs)[sig_roi_index]
#sig_roi_index = as.data.frame(sig_roi_index)

Annotate_roi_pvals = getGene(names(sig_roi_index), type = "ensembl_gene_id", mart = mart)
rownames(Annotate_roi_pvals) = Annotate_roi_pvals$ensembl_gene_id

tem = match(names(sig_roi_index),  rownames(Annotate_roi_pvals))
if(any(is.na(tem) == TRUE)) { sig_roi_index =  sig_roi_index[-which(is.na(tem))] }
tem = tem[!is.na(tem)]
Annotate_roi_pvals = Annotate_roi_pvals[tem,]
Annotate_roi_pvals$Index = sig_roi_index

write.csv(Annotate_roi_pvals,file=file.path(current_rundir,"sigroi_annot_pvals.csv"))

qvals = p.adjust(pvals, method = "fdr")
sig_roi_index = which(qvals < 0.06)
names(sig_roi_index) = colnames(Zs)[sig_roi_index]
Annotate_roi_qvals = getGene(names(sig_roi_index), type = "ensembl_gene_id", mart = mart)
rownames(Annotate_roi_qvals) = Annotate_roi_qvals$ensembl_gene_id

tem = match(names(sig_roi_index),  rownames(Annotate_roi_qvals))
if(any(is.na(tem) == TRUE)) { 
	sig_roi_index =  sig_roi_index[-which(is.na(tem))] 
	tem = tem[!is.na(tem)]
}
Annotate_roi_qvals = Annotate_roi_qvals[tem,]
Annotate_roi_qvals$Index = sig_roi_index

write.csv(Annotate_roi_qvals,file=file.path(current_rundir,"sigroi_annot_qvals.csv"))
return()
}


survival_learning <- function () {
# Searches for combinations of biomarkers that form high surviving patient groups
res_dir = file.path(path,"results_cghexp")
current_rundir = res_dir
Annotate_roi_qvals = read.csv(file=file.path(current_rundir,"sigroi_annot_qvals.csv"), header=T) #ROIs having qvals < 0.05
sig_roi_index = Annotate_roi_qvals$Index
inp = read.delim(file.path(res_dir,"anduril_input_file.txt"))
load(file.path(res_dir,"topModels.RData")) #Zs
noRoi = length(sig_roi_index)
combi = 1+(noRoi-1)^2
grouped_ROIs = matrix(NA,dim(inp)[1],combi)
colnames_grouped_ROIs = vector(length = combi)
dat = list()
k = 0
for(i in 1:(noRoi-1)) { #For pairs
	tm = paste(Annotate_roi_qvals$hgnc_symbol[i],"_",Annotate_roi_qvals$chromosome_name[i],Annotate_roi_qvals$band[i],"_and_",sep = "")
	for(j in (i+1):noRoi) {
		k = k+1
		dat[[1]] = inp[,(sig_roi_index[i]+3)]
		dat[[2]] = inp[,(sig_roi_index[j]+3)]
		if(j == 4) {
			grouped_ROIs[,k] = compute_new_gp(dat, "pos")
		} else {
			grouped_ROIs[,k] = compute_new_gp(dat, "neg")
		}

		colnames_grouped_ROIs[k] = paste(tm, Annotate_roi_qvals$hgnc_symbol[j],"_",Annotate_roi_qvals$chromosome_name[j],Annotate_roi_qvals$band[j],sep = "")
	}
}
indec = list()
indec[[1]] = c(1,2,3)
indec[[2]] = c(1,3,4)
indec[[3]] = c(2,3,4)
flag = "neg"
for(i in 1:3) {	#For triplets
	tm = vector()
	if(i > 1) { flag = "pos" }
	for(j in 1:3) {
		tm = paste(tm, Annotate_roi_qvals$hgnc_symbol[indec[[i]][j]],"_",Annotate_roi_qvals$chromosome_name[indec[[i]][j]],Annotate_roi_qvals$band[indec[[i]][j]],sep = "")
	}
	dat[[1]] = inp[,(sig_roi_index[indec[[i]][1]]+3)]
        dat[[1]] = inp[,(sig_roi_index[indec[[i]][2]]+3)]
        dat[[2]] = inp[,(sig_roi_index[indec[[i]][3]]+3)]
        grouped_ROIs[,k+i] = compute_new_gp(dat,flag)
	colnames_grouped_ROIs[k+i] = tm
}
#For Quad 
dat[[1]] = inp[,(sig_roi_index[1]+3)]
dat[[2]] = inp[,(sig_roi_index[2]+3)]
dat[[1]] = inp[,(sig_roi_index[3]+3)]
dat[[2]] = inp[,(sig_roi_index[4]+3)]
grouped_ROIs[,combi] = compute_new_gp(dat,"pos")
colnames_grouped_ROIs[combi] = paste(Annotate_roi_qvals$hgnc_symbol,collapse="_")
colnames(grouped_ROIs) = colnames_grouped_ROIs

#Anduril input
rownames(grouped_ROIs) = inp$ID
inp2 = matrix()
inp2 = cbind(inp[,1:3],grouped_ROIs)
#inp2 = inp2[,-1]
#inp2 = inp2[-c(which(inp2$VitalStatus == "NA")),]

write.table(inp2, file=file.path(current_rundir,"anduril_input_file_multi.txt"),row.names=FALSE, sep="\t", quote = FALSE)

#ROI significances and annotation
stat_table = read.delim(file.path(current_rundir,"km_anduril_multi","final_camda_multi","km","statistics.csv"))

pvals = stat_table$pValue #Pvalues for each ROI based on KM analysis.
sig_roi_index = which(pvals < 0.05) #Significant ROIs

qvals = p.adjust(pvals, method = "fdr")
sig_roi_index = which(qvals < 0.06) # All combinations have high survival association.
return()
}
