% generate simple test data for testing DCA.
% In this data, class centers vary along dimensions 2 and 5

data=[];
n_classes=10;
n_dim = 5;
n_dataperclass = 50;
n_outputdim = 2;

common_center = 5*randn(1,n_dim);

for k=1:n_classes,
  center = common_center; 
  center(3) = 5*randn; center(4) = 5*randn;
  classdata = randn(n_dataperclass,n_dim);
  classdata = classdata + repmat(center,[size(classdata,1) 1]);
  classdata = [classdata zeros(size(classdata,1),n_classes)];
  classdata(:,n_dim+k) = 1;
  data = [data;classdata];
end;

save mydata.txt data -ASCII

A=eye(n_dim);
save initial_pretransformation.txt A -ASCII

W=A(:,1:n_outputdim);
save initial_projection.txt W -ASCII

