/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;

public class eyediagram
extends PApplet {
    PGraphics graphics;
    PFont font;
    PFont fontBold;
    float r;
    float theta;
    float min_theta;
    float max_theta;
    Location[] wordLocations;
    Location[] documentLocations;
    Location[] topicLocations;
    float[][] d2t;
    float[][] w2t;
    String[] words;
    String[] documents;
    String[] topics;
    String[] topicNames;
    String filepath;
    String[] params;
    String folder;
    String outputfile;
    int topicCount;
    String[] infoText;
    int highlightedTopic;
    String[] fontSizes;
    String[] radiusAdjs;
    String[] curveFactors;
    String[] docColors;
    String[] wordColors;
    int docFontSize;
    int wordFontSize;
    int topicFontSize;
    int infoFontSize;
    int topicWidth;
    int topicHeight;
    int rAdjustmentWords;
    int rAdjustmentDocs;
    float topicSpreadFactor;
    float docCurveFactor;
    float wordCurveFactor;
    int d2tCurveWidthFactor;
    int w2tCurveWidthFactor;
    int d2tCurveAlphaFactor;
    int w2tCurveAlphaFactor;

    public void setup() {
        this.size(this.screen.width, this.screen.height, "processing.core.PGraphicsJava2D");
        this.hint(3);
        this.font = this.createFont("Arial", 24.0f);
        this.fontBold = this.createFont("Arial Bold", 24.0f);
        this.filepath = "./example/";
        this.params = this.readNames(String.valueOf(this.filepath) + "input/parameters.txt");
        this.outputfile = this.params[0];
        this.topicCount = Integer.parseInt(this.params[1]);
        this.highlightedTopic = Integer.parseInt(this.params[2]);
        this.infoText = this.readNames(String.valueOf(this.filepath) + "input/infotext.txt");
        this.words = this.readNames(String.valueOf(this.filepath) + "input/word_names.txt");
        this.documents = this.readNames(String.valueOf(this.filepath) + "input/doc_names.txt");
        this.topics = this.readNames(String.valueOf(this.filepath) + "input/topics.txt");
        this.topicNames = this.readNames(String.valueOf(this.filepath) + "input/topic_names.txt");
        this.d2t = this.readMatrix(String.valueOf(this.filepath) + "input/doc2topic.txt", "\t");
        this.w2t = this.readMatrix(String.valueOf(this.filepath) + "input/word2topic.txt", "\t");
        this.fontSizes = this.readNames(String.valueOf(this.filepath) + "input/font_sizes.txt");
        this.docFontSize = Integer.parseInt(this.fontSizes[0]);
        this.wordFontSize = Integer.parseInt(this.fontSizes[1]);
        this.topicFontSize = Integer.parseInt(this.fontSizes[2]);
        this.infoFontSize = Integer.parseInt(this.fontSizes[3]);
        this.topicWidth = Integer.parseInt(this.fontSizes[4]);
        this.topicHeight = Integer.parseInt(this.fontSizes[5]);
        this.radiusAdjs = this.readNames(String.valueOf(this.filepath) + "input/radius_adjustments.txt");
        this.rAdjustmentDocs = Integer.parseInt(this.radiusAdjs[0]);
        this.rAdjustmentWords = Integer.parseInt(this.radiusAdjs[1]);
        this.topicSpreadFactor = Float.parseFloat(this.radiusAdjs[2]);
        this.docCurveFactor = Float.parseFloat(this.radiusAdjs[3]);
        this.wordCurveFactor = Float.parseFloat(this.radiusAdjs[4]);
        this.max_theta = Float.parseFloat(this.radiusAdjs[5]) / 90.0f * 1.5707964f;
        this.min_theta = -this.max_theta;
        this.curveFactors = this.readNames(String.valueOf(this.filepath) + "input/curve_factors.txt");
        this.d2tCurveWidthFactor = Integer.parseInt(this.curveFactors[0]);
        this.w2tCurveWidthFactor = Integer.parseInt(this.curveFactors[1]);
        this.d2tCurveAlphaFactor = Integer.parseInt(this.curveFactors[2]);
        this.w2tCurveAlphaFactor = Integer.parseInt(this.curveFactors[3]);
        this.docColors = this.readNames(String.valueOf(this.filepath) + "input/doc_colors.txt");
        this.wordColors = this.readNames(String.valueOf(this.filepath) + "input/word_colors.txt");
        this.wordLocations = new Location[this.words.length];
        this.documentLocations = new Location[this.documents.length];
        this.topicLocations = new Location[this.topicCount];
        this.graphics = this.createGraphics(2100, 2950, "processing.pdf.PGraphicsPDF", String.valueOf(this.outputfile) + ".pdf");
        this.exportPDF(this.graphics);
    }

    public void draw() {
        this.exit();
    }

    public void exportPDF(PGraphics pGraphics) {
        String string;
        float f;
        float f2;
        int n = 2100;
        int n2 = 2950;
        pGraphics.beginDraw();
        pGraphics.background(-1);
        pGraphics.fill(0);
        pGraphics.scale(1.0f);
        pGraphics.strokeCap(1);
        pGraphics.textFont(this.font, (float)this.wordFontSize);
        float f3 = this.maxTextWidth(pGraphics, this.words);
        this.r = (float)(eyediagram.min((int)n, (int)n2) / 2) - f3 + (float)this.rAdjustmentWords;
        this.theta = this.min_theta;
        float f4 = 0.0f;
        if (this.highlightedTopic != -1) {
            f4 = this.sum(this.w2t, this.highlightedTopic);
        }
        float f5 = 0.9f;
        int n3 = 0;
        while (n3 < this.words.length) {
            if (this.highlightedTopic == -1) {
                f2 = (this.max_theta - this.min_theta) / (float)this.words.length;
                pGraphics.textFont(this.font, (float)this.wordFontSize);
            } else {
                f = this.w2t[n3][this.highlightedTopic] / f4 * (float)this.words.length;
                f2 = f5 * ((this.max_theta - this.min_theta) / (float)this.words.length) + (1.0f - f5) * f * ((this.max_theta - this.min_theta) / (float)this.words.length);
                pGraphics.textFont(this.font, f5 * (float)this.wordFontSize + (1.0f - f5) * (float)this.wordFontSize * f);
            }
            string = this.words[n3];
            pGraphics.pushMatrix();
            pGraphics.translate((float)(pGraphics.width / 2 - 200), (float)(pGraphics.height / 2));
            pGraphics.rotate(this.theta + 0.5f * f2);
            pGraphics.ellipseMode(3);
            pGraphics.noStroke();
            this.wordLocations[n3] = new Location(this.r * eyediagram.cos((float)(this.theta + 0.5f * f2)) - 200.0f, this.r * eyediagram.sin((float)(this.theta + 0.5f * f2)));
            pGraphics.popMatrix();
            pGraphics.fill(0);
            pGraphics.stroke(0);
            pGraphics.pushMatrix();
            pGraphics.translate((float)(pGraphics.width / 2 - 200), (float)(pGraphics.height / 2));
            pGraphics.rotate(this.theta + 0.5f * f2);
            pGraphics.textAlign(37, 3);
            if (this.wordColors[n3].equals("black")) {
                pGraphics.fill(0.0f, 0.0f, 0.0f);
            }
            if (this.wordColors[n3].equals("red")) {
                pGraphics.fill(255.0f, 0.0f, 0.0f);
            }
            if (this.wordColors[n3].equals("green")) {
                pGraphics.fill(0.0f, 255.0f, 0.0f);
            }
            if (this.wordColors[n3].equals("blue")) {
                pGraphics.fill(0.0f, 0.0f, 255.0f);
            }
            pGraphics.text(string, this.r + 4.0f, 0.0f);
            pGraphics.popMatrix();
            this.theta += f2;
            ++n3;
        }
        pGraphics.textFont(this.font, (float)this.docFontSize);
        f3 = this.maxTextWidth(pGraphics, this.documents);
        this.r = (float)(eyediagram.min((int)n, (int)n2) / 2) - f3 + (float)this.rAdjustmentDocs;
        this.theta = this.min_theta - 2.0f * (1.5707964f + this.min_theta);
        if (this.highlightedTopic != -1) {
            f4 = this.sum(this.d2t, this.highlightedTopic);
        }
        n3 = 0;
        while (n3 < this.documents.length) {
            if (this.highlightedTopic == -1) {
                f2 = (this.max_theta - this.min_theta) / (float)this.documents.length;
                pGraphics.textFont(this.font, (float)this.docFontSize);
            } else {
                f = this.d2t[n3][this.highlightedTopic] / f4 * (float)this.documents.length;
                f2 = f5 * ((this.max_theta - this.min_theta) / (float)this.documents.length) + (1.0f - f5) * f * ((this.max_theta - this.min_theta) / (float)this.documents.length);
                pGraphics.textFont(this.font, f5 * (float)this.docFontSize + (1.0f - f5) * (float)this.docFontSize * f);
            }
            string = this.documents[n3];
            pGraphics.pushMatrix();
            pGraphics.translate((float)(pGraphics.width / 2 - 100), (float)(pGraphics.height / 2));
            pGraphics.rotate(this.theta - 0.5f * f2);
            pGraphics.ellipseMode(3);
            pGraphics.noStroke();
            this.documentLocations[n3] = new Location(this.r * eyediagram.cos((float)(this.theta - 0.5f * f2)) - 250.0f, this.r * eyediagram.sin((float)(this.theta - 0.5f * f2)));
            pGraphics.popMatrix();
            pGraphics.fill(0);
            pGraphics.stroke(0);
            pGraphics.pushMatrix();
            float f6 = pGraphics.textWidth(string);
            Location location = new Location((this.r + f6 + 4.0f) * eyediagram.cos((float)(this.theta - 0.5f * f2)) - 250.0f, (this.r + f6 + 4.0f) * eyediagram.sin((float)(this.theta - 0.5f * f2)));
            pGraphics.translate((float)(pGraphics.width / 2), (float)(pGraphics.height / 2));
            pGraphics.translate(location.x, location.y);
            pGraphics.rotate(this.theta - 0.5f * f2 + eyediagram.radians((float)180.0f));
            pGraphics.textAlign(37, 3);
            if (this.docColors[n3].equals("black")) {
                pGraphics.fill(0.0f, 0.0f, 0.0f);
            }
            if (this.docColors[n3].equals("red")) {
                pGraphics.fill(255.0f, 0.0f, 0.0f);
            }
            if (this.docColors[n3].equals("green")) {
                pGraphics.fill(0.0f, 100.0f, 0.0f);
            }
            if (this.docColors[n3].equals("blue")) {
                pGraphics.fill(0.0f, 0.0f, 255.0f);
            }
            pGraphics.text(string, 0.0f, 0.0f);
            pGraphics.popMatrix();
            this.theta -= f2;
            ++n3;
        }
        pGraphics.translate((float)(pGraphics.width / 2), (float)(pGraphics.height / 2));
        this.calculateTopicLocations(this.topicCount);
        pGraphics.noFill();
        pGraphics.colorMode(3, 1.0f);
        n3 = 0;
        while (n3 < this.d2t.length) {
            int n4 = 0;
            while (n4 < this.d2t[n3].length) {
                pGraphics.pushMatrix();
                pGraphics.translate(this.topicLocations[n4].x, this.topicLocations[n4].y);
                pGraphics.noFill();
                Location location = new Location(-this.r / 8.0f - (this.r - 2.0f * eyediagram.abs((float)this.topicLocations[n4].y)) * this.docCurveFactor, 0.0f);
                if (this.highlightedTopic != -1) {
                    if (n4 == this.highlightedTopic) {
                        pGraphics.stroke(1.0f / (float)this.topicCount * (float)n4, 0.8f, 0.8f, this.d2t[n3][n4] * (float)this.d2tCurveAlphaFactor);
                    } else {
                        pGraphics.stroke(1.0f / (float)this.topicCount * (float)n4, 0.0f, 0.8f, this.d2t[n3][n4] * (float)this.d2tCurveAlphaFactor / 5.0f);
                    }
                } else {
                    pGraphics.stroke(1.0f / (float)this.topicCount * (float)n4, 0.8f, 0.8f, this.d2t[n3][n4] * (float)this.d2tCurveAlphaFactor);
                }
                pGraphics.strokeWeight((float)this.d2tCurveWidthFactor * this.d2t[n3][n4]);
                pGraphics.bezier(0.0f, 0.0f, location.x, location.y, location.x, location.y, this.documentLocations[n3].x - this.topicLocations[n4].x, this.documentLocations[n3].y - this.topicLocations[n4].y);
                pGraphics.popMatrix();
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.w2t.length) {
            int n5 = 0;
            while (n5 < this.w2t[n3].length) {
                pGraphics.pushMatrix();
                pGraphics.translate(this.topicLocations[n5].x, this.topicLocations[n5].y);
                pGraphics.noFill();
                Location location = new Location(this.r / 8.0f + (this.r - 2.0f * eyediagram.abs((float)this.topicLocations[n5].y)) * this.wordCurveFactor, 0.0f);
                if (this.highlightedTopic != -1) {
                    if (n5 == this.highlightedTopic) {
                        pGraphics.stroke(1.0f / (float)this.topicCount * (float)n5, 0.8f, 0.8f, this.w2t[n3][n5] * (float)this.w2tCurveAlphaFactor);
                    } else {
                        pGraphics.stroke(1.0f / (float)this.topicCount * (float)n5, 0.0f, 0.8f, this.w2t[n3][n5] * (float)this.w2tCurveAlphaFactor / 5.0f);
                    }
                } else {
                    pGraphics.stroke(1.0f / (float)this.topicCount * (float)n5, 0.8f, 0.8f, this.w2t[n3][n5] * (float)this.w2tCurveAlphaFactor);
                }
                pGraphics.strokeWeight((float)this.w2tCurveWidthFactor * this.w2t[n3][n5]);
                pGraphics.bezier(0.0f, 0.0f, location.x, location.y, location.x, location.y, this.wordLocations[n3].x - this.topicLocations[n5].x, this.wordLocations[n3].y - this.topicLocations[n5].y);
                pGraphics.popMatrix();
                ++n5;
            }
            ++n3;
        }
        this.drawTopics(pGraphics, this.topicCount, this.r, this.topicNames);
        pGraphics.textAlign(37);
        pGraphics.textFont(this.font, (float)this.infoFontSize);
        n3 = 0;
        while (n3 < this.infoText.length) {
            pGraphics.text(this.infoText[n3], -800.0f, (float)(-1200 + 50 * n3));
            ++n3;
        }
        pGraphics.dispose();
        pGraphics.endDraw();
    }

    public float maxTextWidth(PGraphics pGraphics, String[] stringArray) {
        float f = 0.0f;
        int n = 0;
        while (n < stringArray.length) {
            float f2 = pGraphics.textWidth(stringArray[n]);
            if (f < f2) {
                f = f2;
            }
            ++n;
        }
        return f;
    }

    public void calculateTopicLocations(int n) {
        int n2 = 0;
        while (n2 < n) {
            float f = (float)n2 * this.r / ((float)n - this.topicSpreadFactor) - this.r / 2.0f - this.topicSpreadFactor * (float)n / 2.0f;
            this.topicLocations[n2] = new Location(-200.0f, f);
            ++n2;
        }
    }

    public void drawTopics(PGraphics pGraphics, int n, float f, String[] stringArray) {
        pGraphics.ellipseMode(3);
        pGraphics.noStroke();
        pGraphics.colorMode(3, 1.0f);
        int n2 = 0;
        while (n2 < n) {
            pGraphics.stroke(1.0f / (float)n * (float)n2, 0.8f, 0.8f, 1.0f);
            pGraphics.strokeWeight(4.0f);
            pGraphics.fill(1);
            pGraphics.ellipse(this.topicLocations[n2].x, this.topicLocations[n2].y, (float)this.topicWidth, (float)this.topicHeight);
            pGraphics.fill(0);
            pGraphics.textFont(this.font, (float)this.topicFontSize);
            pGraphics.textAlign(3, 3);
            pGraphics.text(stringArray[PApplet.parseInt((String)this.topics[n2]) - 1], this.topicLocations[n2].x, this.topicLocations[n2].y - 2.0f);
            ++n2;
        }
    }

    public float[][] readMatrix(String string, String string2) {
        String[] stringArray = this.loadStrings(string);
        int n = stringArray.length;
        int n2 = 0;
        if (n > 0) {
            n2 = stringArray[0].split(string2).length;
        }
        float[][] fArray = new float[n][n2];
        int n3 = 0;
        while (n3 < stringArray.length) {
            String[] stringArray2 = stringArray[n3].split(string2);
            int n4 = 0;
            while (n4 < stringArray2.length) {
                fArray[n3][n4] = new Float(stringArray2[n4]).floatValue();
                ++n4;
            }
            ++n3;
        }
        return fArray;
    }

    public String[] readNames(String string) {
        String[] stringArray = this.loadStrings(string);
        return stringArray;
    }

    public float max(float[][] fArray, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < fArray.length) {
            if (fArray[n2][n] > f) {
                f = fArray[n2][n];
            }
            ++n2;
        }
        return f;
    }

    public float sum(float[][] fArray, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < fArray.length) {
            f += fArray[n2][n];
            ++n2;
        }
        return f;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "eyediagram"});
    }
}

