# Copyright (C) 2010 Tommi Suvitaival and Ilkka Huopaniemi
#
# This file is part of multiWayCCA.
#
# multiWayCCA is free software: you can redistribute it and/or modify
# it under the terms of the Lesser GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# multiWayCCA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with multiWayCCA.  If not, see <http://www.gnu.org/licenses/>.


## Tommi Suvitaival 4.11.09
# Plot a boxplot with normal quartiles but instead of whiskers of length 1.5x'interquantile range', plot whiskers according to the confidence intervals
# Arguments:
# x - position of the box on the x-axis
# y - data
# confidence - the confidence level; default is 0.95
# lwd - line width of the plot
# add - TRUE/FALSE: do/do not add the box to an existing plot

boxCI = function(x, confidence=0.95, add=F, at=1, lwd=1, width=NULL, xlim=NULL, ylim=NULL, xaxt="n", cex=0.5, ylab="") {

	library(gplots)
	
	uncertainty = 1-confidence
	if (add==F) { # Start a new figure.
		boxplot(x=x, at=at, range=1e-18, col="white", outline=F, lwd=lwd, add=F, width=width, xlim=xlim, ylim=ylim, xaxt=xaxt, cex=cex, ylab=ylab)
	}
	
	plotCI(x=at, y=median(x,na.rm=T), uiw=lwd, li=quantile(x,probs=uncertainty/2), ui=quantile(x,probs=(1-uncertainty/2)), add=T, lwd=lwd,lty=1,barcol="black",type="l", gap=0)
	boxplot(x=x, at=at, range=1e-18, col="white", outline=F, lwd=lwd, add=T, cex=cex, width=width, xaxt="n", ylab="", staplewex=0)

	return(TRUE)

}
