create4wayDesignMatrixWithEffects = function(covA, covB, covC, covD, eff=NULL) {

	A = max(covA)
	B = max(covB)
	C = max(covC)
	D = max(covD)

	design = array(data=0, dim=c(length(covA),(A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+B*C*D+A*B*C*D)))
	if (!is.null(eff))
		effMat = array(data=NA, dim=c(ncol(design),ncol(eff$A)))
	else
		effMat = NULL
	
	ind = list()
	ind$vec = list()
	ind$tab = list()
	ind$tab$A = 1:A
	ind$vec$A = ind$tab$A
	if (!is.null(eff))
		effMat[1:A,] = eff$A
	ind$tab$B = A+(1:B)
	ind$vec$B = ind$tab$B
	if (!is.null(eff))
		effMat[A+(1:B),] = eff$B
	ind$tab$C = A+B+(1:C)
	ind$vec$C = ind$tab$C
	if (!is.null(eff))
		effMat[A+B+(1:C),] = eff$C
	ind$tab$D = A+B+C+(1:D)
	ind$vec$D = ind$tab$D
	if (!is.null(eff))
		effMat[A+B+C+(1:D),] = eff$D
	
	ind$tab$AB = array(dim=c(A,B))
	ind$tab$AC = array(dim=c(A,C))
	ind$tab$AD = array(dim=c(A,D))
	ind$tab$BC = array(dim=c(B,C))
	ind$tab$BD = array(dim=c(B,D))
	ind$tab$CD = array(dim=c(C,D))
	ind$tab$ABC = array(dim=c(A,B,C))
	ind$tab$ABD = array(dim=c(A,B,D))
	ind$tab$ACD = array(dim=c(A,C,D))
	ind$tab$BCD = array(dim=c(B,C,D))
	ind$tab$ABCD = array(dim=c(A,B,C,D))

	for (ai in 1:A) {
		design[covA==ai,ai] = 1 # 1
		ind$tab$AB[ai,] = A+B+C+D+(ai-1)*B+(1:B)
		ind$vec$AB = c(ind$vec$AB,ind$tab$AB[ai,])
		ind$tab$AC[ai,] = A+B+C+D+A*B+(ai-1)*C+(1:C)
		ind$vec$AC = c(ind$vec$AC,ind$tab$AC[ai,])
		ind$tab$AD[ai,] = A+B+C+D+A*B+A*C+(ai-1)*D+(1:D)
		ind$vec$AD = c(ind$vec$AD,ind$tab$AD[ai,])
		if (!is.null(eff)) {
			effMat[A+B+C+D+(ai-1)*B+(1:B),] = eff$AB[ai,,]
			effMat[A+B+C+D+A*B+(ai-1)*C+(1:C),] = eff$AC[ai,,]
			effMat[A+B+C+D+A*B+A*C+(ai-1)*D+(1:D),] = eff$AD[ai,,]
		}
		for (bi in 1:B) {
			design[covA==ai&covB==bi,A+B+C+D+(ai-1)*B+bi] = 1 # 5
			if (ai==1) {
				design[covB==bi,A+bi] = 1 # 2
				ind$tab$BC[bi,] = A+B+C+D+A*B+A*C+A*D+(bi-1)*C+(1:C)
				ind$vec$BC = c(ind$vec$BC,ind$tab$BC[bi,])
				ind$tab$BD[bi,] = A+B+C+D+A*B+A*C+A*D+B*C+(bi-1)*D+(1:D)
				ind$vec$BD = c(ind$vec$BD,ind$tab$BD[bi,])
				if (!is.null(eff)) {
					effMat[A+B+C+D+A*B+A*C+A*D+(bi-1)*C+(1:C),] = eff$BC[bi,,]
					effMat[A+B+C+D+A*B+A*C+A*D+B*C+(bi-1)*D+(1:D),] = eff$BD[bi,,]
				}
			}
			ind$tab$ABC[ai,bi,] = A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+(ai-1)*(B*C)+(bi-1)*C+(1:C) # Bug fixed 31.1.11.
			ind$vec$ABC = c(ind$vec$ABC,ind$tab$ABC[ai,bi,])
			ind$tab$ABD[ai,bi,] = A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+(ai-1)*(B*D)+(bi-1)*D+(1:D) # Bug fixed 31.1.11.
			ind$vec$ABD = c(ind$vec$ABD,ind$tab$ABD[ai,bi,])
			if (!is.null(eff)) {
				effMat[A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+(ai-1)*(B*C)+(bi-1)*C+(1:C),] = eff$ABC[ai,bi,,]
				effMat[A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+(ai-1)*(B*D)+(bi-1)*D+(1:D),] = eff$ABD[ai,bi,,]
			}
			for (ci in 1:C) {
				design[covA==ai&covB==bi&covC==ci,A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+(ai-1)*(B*C)+(bi-1)*C+ci] = 1 # 11
				ind$tab$ABCD[ai,bi,ci,] = A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+B*C*D+(ai-1)*(B*C*D)+(bi-1)*(C*D)+(ci-1)*D+(1:D)
				ind$vec$ABCD = c(ind$vec$ABCD,ind$tab$ABCD[ai,bi,ci,])
				if (!is.null(eff)) {
					effMat[A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+B*C*D+(ai-1)*(B*C*D)+(bi-1)*(C*D)+(ci-1)*D+(1:D),] = eff$ABCD[ai,bi,ci,,]
				}
				if (ai==1) {
					design[covB==bi&covC==ci,A+B+C+D+A*B+A*C+A*D+(bi-1)*C+ci] = 1 # 8
					ind$tab$BCD[bi,ci,] = A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+(bi-1)*(C*D)+(ci-1)*D+(1:D)
					ind$vec$BCD = c(ind$vec$BCD,ind$tab$BCD[bi,ci,])
					if (!is.null(eff)) {
						effMat[A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+(bi-1)*(C*D)+(ci-1)*D+(1:D),] = eff$BCD[bi,ci,,]
					}
					if (bi==1) {
						design[covC==ci,A+B+ci] = 1 # 3
						ind$tab$CD[ci,] = A+B+C+D+A*B+A*C+A*D+B*C+B*D+(ci-1)*D+(1:D)
						ind$vec$CD = c(ind$vec$CD,ind$tab$CD[ci,])
						if (!is.null(eff)) {
							effMat[A+B+C+D+A*B+A*C+A*D+B*C+B*D+(ci-1)*D+(1:D),] = eff$CD[ci,,]
						}
					}
				}
				if (bi==1) {
					design[covA==ai&covC==ci,A+B+C+D+A*B+(ai-1)*C+ci] = 1 # 6
					ind$tab$ACD[ai,ci,] = A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+(ai-1)*(C*D)+(ci-1)*D+(1:D)
					ind$vec$ACD = c(ind$vec$ACD,ind$tab$ACD[ai,ci,])
					if (!is.null(eff)) {
						effMat[A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+(ai-1)*(C*D)+(ci-1)*D+(1:D),] = eff$ACD[ai,bi,,]
					}
				}
				for (di in 1:D) {
					design[covA==ai&covB==bi&covC==ci&covD==di, A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+B*C*D+(ai-1)*(B*C*D)+(bi-1)*C*D+(ci-1)*D+di] = 1 # 15
					if (ai==1) {
						design[covB==bi&covC==ci&covD==di,A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+A*C*D+(bi-1)*(C*D)+(ci-1)*D+di] = 1 # 14
						if (bi==1) {
							design[covC==ci&covD==di,A+B+C+D+A*B+A*C+A*D+B*C+B*D+(ci-1)*D+di] = 1 # 10
							if (ci==1) {
								design[covD==di,A+B+C+di] = 1 # 4
							}
						}
						if (ci==1) {
							design[covB==bi&covD==di,A+B+C+D+A*B+A*C+A*D+B*C+(bi-1)*D+di] = 1 # 9
						}
					}
					if (bi==1) {
						design[covA==ai&covC==ci&covD==di,A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+A*B*D+(ai-1)*(C*D)+(ci-1)*D+di] = 1 # 13
						if (ci==1) {
							design[covA==ai&covD==di,A+B+C+D+A*B+A*C+(ai-1)*D+di] = 1 # 7
						}
					}
					if (ci==1) {
						design[covA==ai&covB==bi&covD==di,A+B+C+D+A*B+A*C+A*D+B*C+B*D+C*D+A*B*C+(ai-1)*(B*D)+(bi-1)*D+di] = 1 # 12
					}
				}
			}
		}
	}

	if (is.null(eff))
		return(list(mat=design, ind=ind))
	else
		return(list(mat=design, ind=ind, eff=effMat))

}