# plot a dim(X)[1] x dim(X)[2] matrix with a distribution of dim(X)[3] samples
# Versions:
# 8.6.10 - Argument 'order' added: it describes the order of components.
# 4.11.09 - helper fuction "boxplot" changed to "boxCI" that plots confidence intervals as whiskers

plotMatrixDistribution = function(X, file, confidence=0.95, Xtrue=NULL, pairs=NULL, links=NULL, order=NULL, marginSeparator=FALSE, pdf=FALSE, labels=FALSE) {
	
	if (as.numeric(R.version$major)>=2 & as.numeric(R.version$minor)>=11) {
		plotType = NULL # 22.7.10 for R-2.11.0'
	} else {
		plotType = "cairo1"
	}
	
	if (!is.null(pairs)&!is.null(links)) {
		kX = ncol(X$shared)
		kY = ncol(X$ySp)
		S = dim(X$shared)[3]
		Nps = nrow(X$shared)
		
		if (is.null(order)) {
			order = list()
			order$x = 1:kX
			order$y = 1:kY
		}
		
		if (pdf) {
# 			pdf(paste(file,".pdf",sep=""), width=2.5*(kX+1), height=2.5*(kY+1))
			pdf(paste(file,".pdf",sep=""), width=4*(kX+1), height=2*(kY+1))
# 			cex = 0.5
# 			cex.main = 2
			par(cex=0.5)
			par(cex.main=4.5)
			cex.axis = 3.5
# 			par(cex.axis=2)
			par(mar=c(1.5,3.5,4.5,1)) # bottom, left, top, right
		} else {
			png(paste(file,".png",sep=""), width=200*(kX+1), height=200*(kY+1), type=plotType)
# 			cex = 0.5
# 			cex.main = 2
			par(cex=0.5)
			par(cex.main=2)
		}
		layout(matrix(1:((kX+1)*(kY+1)), ncol=(kY+1), byrow=T))
		
		# Avoid possible 'NA' values in the result of limits by checking whether there are components that have never been active.
		XnaRm = X
		for (i in 1:kX) {
			if (all(is.na(X$shared[,i,]))) {
				XnaRm$shared[,i,] = 0
			} else if (all(is.na(X$xSp[,i,]))) {
				XnaRm$xSp[,i,] = 0
			}
		}
		for (j in 1:kY) {
			if (all(is.na(X$ySp[,j,]))) {
				XnaRm$ySp[,j,] = 0
			}
		}
		
		# Compute limiting values for the plot -26.7.10
		ylim = rep(NA,2)
		uncertainty = 1-confidence
		
		ylim[1] = min(0,apply(X=XnaRm$shared,MARGIN=c(2,3),FUN=quantile,probs=uncertainty/2,na.rm=T), apply(X=XnaRm$xSp,MARGIN=c(2,3),FUN=quantile,probs=uncertainty/2,na.rm=T), apply(X=XnaRm$ySp,MARGIN=c(2,3),FUN=quantile,probs=uncertainty/2,na.rm=T))
		ylim[2] = max(0,apply(X=XnaRm$shared,MARGIN=c(2,3),FUN=quantile,probs=(1-uncertainty/2),na.rm=T), apply(X=XnaRm$xSp,MARGIN=c(2,3),FUN=quantile,probs=(1-uncertainty/2),na.rm=T), apply(X=XnaRm$ySp,MARGIN=c(2,3),FUN=quantile,probs=(1-uncertainty/2),na.rm=T))
		print(ylim)
		
		rm(XnaRm)
		
		cnt = 1
		for (i in 1:kX) { # clusters of X as rows
			screen(cnt)
			cnt = cnt+1
			if (!all(is.na(X$xSp[,i,]))) { # specific effect of x-cluster 'i'
				for (s in S:1) {
					if (s==S) {
	# 					boxCI(mu[,k,s],add=F,at=s,xlim=(c(0,S)+0.5),ylim=c(min(mu,eff0,na.rm=T),max(mu,eff0,na.rm=T)),width=0.8,xaxt="n",cex=0.5,ylab="")
# 						boxCI(X$xSp[,order$x[i],s], add=F, at=s, xlim=(c(0,S)+0.5), ylim=c(min(X$shared,X$xSp,X$ySp,Xtrue,na.rm=T), max(X$shared,X$xSp,X$ySp,Xtrue,na.rm=T)), width=0.8, xaxt="n", ylab="")
						boxCI(X$xSp[,order$x[i],s], add=F, at=s, xlim=(c(0,S)+0.5), ylim=ylim, width=0.8, xaxt="n", ylab="", cex.axis=cex.axis) # pre-computed ylim values -26.7.10
					} else {
	# 					boxCI(mu[,k,s],add=T,at=s,width=0.8,xaxt="n",cex=0.5,ylab="")
						boxCI(X$xSp[,order$x[i],s], add=T, at=s, width=0.8, xaxt="n", ylab="", cex.axis=cex.axis)
					}
				}
				abline(h=0,col="black",lty=2) # horizontal line for zero level.
			} else {
				plot(0,0, bty="n", col.lab="white", type="l", xaxt="n", yaxt="n")
			}
			if (marginSeparator) {
				if (pdf) {
# 					for (l in 3:(-17)) {
# 						mtext("|", at=6.25, cex=par("cex.main")+1, line=l)
# 					}
				} else {
					for (l in 3:(-51)) {
						mtext("|", at=7, line=l)
					}
				}
			}
# 			title(main=paste("xSp",i,"-",round(sum(links[,i]==FALSE)/Nps*100,digits=1),"%"), cex.main=2)
			if (pdf) {
				title(main=paste(round(sum(links[,i]==FALSE)/Nps*100,digits=1)," %"))
			} else {
				title(main=paste("x",i,"-",round(sum(links[,i]==FALSE)/Nps*100,digits=1)," %"))
			}
			for (j in 1:kY) { # shared effect of x-cluster 'i' and y-cluster 'j'
				screen(cnt)
				cnt = cnt+1
				selected = (pairs[,i]==j&links[,i]==TRUE)
				if (!all(is.na(X$shared[selected,order$x[i],]))) {
					for (s in S:1) {
						if (s==S) {
		# 					boxCI(mu[,k,s],add=F,at=s,xlim=(c(0,S)+0.5),ylim=c(min(mu,eff0,na.rm=T),max(mu,eff0,na.rm=T)),width=0.8,xaxt="n",cex=0.5,ylab="")
# 							boxCI(X$shared[selected,order$x[i],s], add=F, at=s, xlim=(c(0,S)+0.5), ylim=c(min(X$shared,X$xSp,X$ySp,Xtrue,na.rm=T), max(X$shared,X$xSp,X$ySp,Xtrue,na.rm=T)), width=0.8, xaxt="n", yaxt="n", ylab="")
							boxCI(X$shared[selected,order$x[i],s], add=F, at=s, xlim=(c(0,S)+0.5), ylim=ylim, width=0.8, xaxt="n", yaxt="n", ylab="", cex.axis=cex.axis) # pre-computed ylim values -26.7.10
						} else {
		# 					boxCI(mu[,k,s],add=T,at=s,width=0.8,xaxt="n",cex=0.5,ylab="")
							boxCI(X$shared[selected,order$x[i],s], add=T, at=s, width=0.8, xaxt="n", yaxt="n", ylab="", cex.axis=cex.axis)
						}
					abline(h=0,col="black",lty=2) # horizontal line for zero level.
					}
				} else {
					plot(0,0, bty="n", col.lab="white", type="l", xaxt="n", yaxt="n")
				}
# 				title(main=paste("sh x",i," y",j," - ",round(sum(selected==TRUE)/Nps*100,digits=1),"%",sep=""), cex.main=2)
				title(main=paste(round(sum(selected==TRUE)/Nps*100,digits=1)," %",sep=""))
			}
		}
		screen(cnt)
		cnt = cnt+1
		plot(0,0, bty="n", cex=0.5, col.lab="white", type="l", xaxt="n", yaxt="n")
# 		if (marginSeparator) {
# 			mtext(paste(rep("_",25),collapse=""), at=2.5, line=5.5)
# 			for (l in 3:(-22)) {
# 				mtext("|", at=7, line=l)
# 			}
# 		}
		for (j in 1:kY) { # specific effect of y-cluster 'j'
			screen(cnt)
			cnt = cnt+1
			if (!all(is.na(X$ySp[,order$y[j],]))) {
				if (j==1) {
					yaxt = "s"
				} else {
					yaxt = "n"
				}
				for (s in S:1) {
					if (s==S) {
	# 					boxCI(mu[,k,s],add=F,at=s,xlim=(c(0,S)+0.5),ylim=c(min(mu,eff0,na.rm=T),max(mu,eff0,na.rm=T)),width=0.8,xaxt="n",cex=0.5,ylab="")
# 						boxCI(X$ySp[,order$y[j],s], add=F, at=s, xlim=(c(0,S)+0.5), ylim=c(min(X$shared,X$xSp,X$ySp,Xtrue,na.rm=T), max(X$shared,X$xSp,X$ySp,Xtrue,na.rm=T)), width=0.8, xaxt="n", yaxt=yaxt, ylab="")
						boxCI(X$ySp[,order$y[j],s], add=F, at=s, xlim=(c(0,S)+0.5), ylim=ylim, width=0.8, xaxt="n", yaxt=yaxt, ylab="", cex.axis=cex.axis) # pre-computed
					} else {
	# 					boxCI(mu[,k,s],add=T,at=s,width=0.8,xaxt="n",cex=0.5,ylab="")
						boxCI(X$ySp[,order$y[j],s], add=T, at=s, width=0.8, xaxt="n", yaxt=yaxt, ylab="", cex.axis=cex.axis)
					}
				}
				abline(h=0,col="black",lty=2) # horizontal line for zero level.
			} else {
				plot(0,0, bty="n", col.lab="white", type="l", xaxt="n", yaxt="n")
			}
			if (marginSeparator) {
				if (pdf) {
# 					mtext(paste(rep("_",7),collapse=""), at=2.6, cex=par("cex.main")+2, line=3.5)
				} else {
					mtext(paste(rep("_",45),collapse=""), at=-2, line=5.5)
				}
			}
# 			title(main=paste("ySp",j,"-",round((Nps-sum(pairs==j&links==TRUE))/Nps*100,digits=1),"%"), cex.main=2)
			if (pdf) {
				title(main=paste(round((Nps-sum(pairs==j&links==TRUE))/Nps*100,digits=1)," %"))
			} else {
				title(main=paste("y",j,"-",round((Nps-sum(pairs==j&links==TRUE))/Nps*100,digits=1)," %"))
			}
		}
		dev.off()
	} else {
		nr = nrow(X)
		nc = ncol(X)
		maxCols = 50 # maximum number of columns of cells for the layout function
		maxCells = 500 # maximum number of cells for the layout function
		if (nc>maxCols) { # Select only first columns (samples) into the figure.
			nc = maxCols
			X = X[,1:nc,,drop=F]
		}
		if (nr*nc>maxCells) {
			tmp = floor(maxCells/nr)
			if (tmp<maxCols)
				nc = tmp
		}
		ylim = c(min(0,X,Xtrue), max(0,X,Xtrue))
		png(paste(file,".png",sep=""),width=200*nc,height=200*nr,type=plotType)
		layout(matrix(1:(nr*nc),ncol=nc,byrow=T))
		cnt = 1
		for (i in 1:nr) {
			for (j in 1:nc) {
				screen(cnt)
	# 			boxplot(X[i,j,],ylim=c(-1,1)*1.1*max(abs(X[i,j,])))
# 				boxCI(X[i,j,],ylim=c(-1,1)*1.1*max(abs(X[i,j,]))) # 4.11.09
				boxCI(X[i,j,],ylim=ylim) # 4.11.10
				abline(h=0)
				if (!is.null(Xtrue)) {
					abline(h=Xtrue[i,j],col="red")
				}
				# Labels
				if (labels) {
					if (j==1)
						title(ylab=paste("Cluster",i),line=2.5)
					if (i==1) {
						if (j==1)
							title(main="Shared loading    ",line=0.9)
						if (j==2)
							title(main="X-specific loading      ",line=0.9)
						if (j==3)
							title(main="Y-specific loading      ",line=0.9)
					}
				}
				cnt = cnt+1
			}
		}
		dev.off()
	}

}