# 19.10.10 - argument 'ylab' added
# 15.4.10 - NA conversion into zeros added
# 6.4.10 - NA handling added
# 6.4.10 - two-dimensional array handling added

plotSeries = function(x, fname, byrow=F, NAasZero=FALSE, ylab=NULL) {

	if (as.numeric(R.version$major)>=2 & as.numeric(R.version$minor)>=11) {
		plotType = NULL # 22.7.10 for R-2.11.0'
	} else {
		plotType = "cairo1"
	}

	if (NAasZero) { # Optionally, set NA values to zero.
		x[is.na(x)] = 0
	}

	if (is.null(dim(x))) {
		png(fname,height=650,width=650,type=plotType)
		plot(x,type="l")
	} else {
		nSamples = dim(x)[1]
		sp = 1:nSamples # Select which samples are to be plotted.
		if (nSamples>100) { # If the series is long, plot only every 5th sample.
			sp = sp[sp%%5==0]
		}
		if (length(dim(x))==2) {
			I = ncol(x)
			png(fname,height=200,width=200*I,type=plotType)
			layout(matrix(1:I,ncol=I,byrow=byrow))
			if (is.null(ylab)) {
				ylab = 1:I
			}
			for (i in 1:I) {
				screen(i)
				if (all(is.na(x[sp,i]))) {
					plot(0,0, ylab=ylab[i])
				} else {
					plot(sp,x[sp,i],type="l",ylab=ylab[i])
				}
			}
		}
		if (length(dim(x))==3) {
			I = ncol(x)
			J = dim(x)[3]
			png(fname,height=200*J,width=200*I,type=plotType)
			layout(matrix(1:(I*J),ncol=I,byrow=byrow))
			for (i in 1:I) {
				for (j in 1:J) {
					screen(i*j)
					if (all(is.na(x[sp,i,j]))) {
						plot(0,0, ylab=i)
					} else {
						plot(sp,x[sp,i,j],type="l",ylab=paste(i,",",j,sep=""))
					}
				}
			}
		} else if (length(dim(x))==4) {
			I = ncol(x)
			J = dim(x)[3]
			png(fname,height=300*J,width=300*I,type=plotType)
			layout(matrix(1:(I*J),ncol=I,byrow=byrow))
			for (i in 1:I) {
				for (j in 1:J) {
					screen(i*j)
					if (all(is.na(x[sp,i,j,]))) {
						plot(0,0, ylab=i)
					} else {
						matplot(sp,x[sp,i,j,],type="l",ylab=paste(i,",",j,sep=""))
					}
				}
			}
		}
	}
	
	dev.off()
}