#####
# A function for plotting cluster-specific mu parameters' posterior samples into boxplots. If enough parameters are given, also sick individuals' personal time series are plotted into the same figure.
# Version history
# 29.10.09 - argument 'bLevel' added. It tells the level of covariate 'b' when plotting cross effect of covariates 'a' and 'b'.
# 4.11.09 - helper function "boxplot" changed to "boxCI", which is self written and uses proper confidence intervals instead of a multiple of interquartile range; this version requires function "boxCI"
# 11.11.09 - argument 'aLevel' added; it decides the lowest level of the treatment 'a'
# 25.11.09 - argument 'byRow' added to enablo plotting by rows instead of columns
# 15.4.10 - NA conversion into zeros added
#####

timedevelop = function(mu, path, fname, effLab=c("a","b"), effLev=1, eff0=NULL, NAasZero=FALSE) {

	K = dim(mu)[2] # number of clusters
	S = dim(mu)[3] # number of (HMM) states

	if (NAasZero) { # Optionally, set NA values to zero.
		mu[is.na(mu)] = 0
	}
	
	if (as.numeric(R.version$major)>=2 & as.numeric(R.version$minor)>=11) {
		png(paste(path,fname,".png",sep=""),width=300*K,height=600) # 22.7.10 for R-2.11.0'
	} else {
		png(paste(path,fname,".png",sep=""),width=300*K,height=600,type="cairo1")
	}
	layout(matrix(1:K,nrow=1))
	#fs = 1.5
	fs = 1.25
	mrg = 1
	par(cex=fs)
	par(cex.axis=fs*1.375)
	par(cex.lab=fs*1.25)
	#par(cex.axis=fs,cex.lab=fs,cex.main=fs)
	if (effLab==1 | effLab==2) {
		par(cex.main=fs*1.5)
		par(mar=c(9,4,4,2)*mrg) # margins of a figure
	} else if (effLab==12) {
		par(cex.main=fs*1.4)
		par(mar=c(11,4,4,2)*mrg) # margins of a figure
	}
		
	# Create a plot of K subplot, each consisting of S boxplots.
	for (k in 1:K) {
		screen(k)
		# Create a new boxplot of S separate plots.
		# For a technical reason, boxplots are added in reversed order.
		for (s in S:1) {
			if (s==S) {
				boxCI(mu[,k,s],add=F,at=s,xlim=(c(0,S)+0.5),ylim=c(min(mu,eff0,na.rm=T),max(mu,eff0,na.rm=T)),width=0.8,xaxt="n",cex=0.5,ylab="")
			} else {
				boxCI(mu[,k,s],add=T,at=s,width=0.8,xaxt="n",cex=0.5,ylab="")
			}
		}
# 			points(eff0[k,], pch="*", cex=2) # Commented out 6.4.10.
		abline(h=0,col="black",lty=2) # horizontal line for zero level.
		if (k==1) {
			if (length(effLab)==1) {
				title(ylab=paste("Effect of covariate ", effLab, sep=""))
			} else if (length(effLab)==2) {
				title(ylab=paste("Interaction effect of covariates ", effLab[1], "=", effLev[1], ", ", effLab[2], sep=""))
			} else if (length(effLab)==3) {
				title(ylab=paste("Interaction effect of covariates ", effLab[1], "=", effLev[1], ", ", effLab[2], "=", effLev[2], ", ", effLab[3], sep=""))
			} else if (length(effLab)==4) {
				title(ylab=paste("Interaction effect of covariates ", effLab[1], "=", effLev[1], ", ", effLab[2], "=", effLev[2], ", ", effLab[3], "=", effLev[3], ", ", effLab[4], sep=""))
			}
			title(main="Shared")
		} else if (k==2) {
			title(main="X-specific")
		} else if (k==3) {
			title(main="Y-specific")
		}
		for (s in 1:S) {
			axis(side=1, at=s, las=3, labels=paste(effLab[length(effLab)],"=",s,sep=""))
		}
	}

	dev.off()

}
