package jmprojection;

/**
 * Used in AdjacencyList to describe nodes adjacent to a given node. Every
 * object of this class is just a data-construct incorporating pointers to a
 * node and distance to that node from some other node. For more on use see
 * AdjacencyList.<br>
 *
 * @see AdjacencyList <br>
 * @author Jarkko Miettinen
 */
public class NodeKeyPair
{
	private FibNode node;

	private double key;

	public NodeKeyPair(FibNode node, double key)
	{
		this.node = node;
		this.key = key;
	}

	public FibNode getNode()
	{
		return node;
	}

	public double getKey()
	{
		return key;
	}

	public String toString()
	{
		StringBuffer sb = new StringBuffer(10);
		sb = sb.append('{').append(node.getId()).append(',').append(this.key)
				.append('}');
		return sb.toString();
	}

	public boolean equals(Object o)
	{
		if (o instanceof NodeKeyPair)
		{
			NodeKeyPair anotherPair = (NodeKeyPair) o;
			return node.equals(anotherPair.getNode());
		}
		return false;
	}

	public int hashCode()
	{
		return node.hashCode();
	}
}
