package jmprojection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

/**
 *
 */

/**
 * @author belmie
 */
public class PrimMST {

	private final static Random r = new Random(System.currentTimeMillis());

	private AdjacencyList graph;

	private int[] genRandPermutation(final int len)
	{
		int permArray[];
		int rnumber;
		int temp;

		permArray = new int[len];
		for (int i = 0; i < len; i++)
		{
			permArray[i] = i;
		}
		for (int i = 0; i < len; i++)
		{
			rnumber = r.nextInt(len);
			temp = permArray[rnumber];
			permArray[rnumber] = permArray[i];
			permArray[i] = temp;
		}
		return permArray;
	}

	public PrimMST(AdjacencyList graph)
	{
		this.graph = graph;
	}

	public AdjacencyList generateMST()
	{
		return generateSpanningTrees(1);
	}

	public AdjacencyList generateSpanningTrees(int amount)
	{
		int permArray[];
		int numberOfNodes;
		AdjacencyList spanningForest;

		numberOfNodes = graph.getNodes().length;
		if (amount <= 0 || amount > numberOfNodes)
		{
			throw new IllegalArgumentException("number of spanning " +
					"trees to create was too small or large");
		}


		spanningForest = new AdjacencyList(graph.getNodes());
		permArray = genRandPermutation(numberOfNodes);
		for (int i = 0; i < amount; i++)
		{
			findMST(graph.getNodes()[permArray[i]], spanningForest);
		}
		return spanningForest;
	}

	/**
	 * @param startNode
	 * @param spanningForest
	 */
	private void findMST(FibNode startNode, AdjacencyList spanningForest)
	{
		FibNode nodes[] = graph.getNodes();
		FibNode extracted;
		FibHeap priorityQueue = new FibHeap();
		Set<FibNode> alreadyRemoved = new HashSet<FibNode>(nodes.length);

		for (int i = 0; i < nodes.length; i++)
		{
			nodes[i].reset();
			if (nodes[i] == startNode)
			{
				startNode.setKey(0);
			}
			else
			{
				nodes[i].setKey(Double.POSITIVE_INFINITY);
			}
			priorityQueue.insert(nodes[i]);
		}

		while((extracted = priorityQueue.extractMin()) != null)
		{
			Iterator<NodeKeyPair> iter;

			alreadyRemoved.add(extracted);
			if(extracted.getObjectKey() != null)
			{
				spanningForest.addBiConnection(extracted,
						(FibNode)extracted.getObjectKey(),
						extracted.getKey());
			}

			iter = graph.getIterator(extracted);
			while(iter.hasNext())
			{
				NodeKeyPair edge;
				double edgeKey;
				FibNode node;
				edge = iter.next();
				edgeKey = edge.getKey();
				node = edge.getNode();

				if (!alreadyRemoved.contains(node) &&
						priorityQueue.getMin() != null &&
						edgeKey < node.getKey())
				{
					priorityQueue.decreaseKey(edge.getNode(), edgeKey);
					edge.getNode().setObjectKey(extracted);
				}
			}
		}
	}

}
