function Y = construct_grid( recgridsize, kind, plotit )
%UNTITLED8 Summary of this function goes here
%   Detailed explanation goes here
if nargin < 3,
    plotit = false;
end
if nargin < 2,
    kind = 'hexagonal';
end
if nargin < 1,
    error('Not enough input arguments.')
end
if strcmp(kind,'hexagonal')
%     disp('hexagonal grid');
    numNeurons = recgridsize*recgridsize;
    dimensions = [recgridsize recgridsize];
    pos = hextop(dimensions);%     topologyFcn = 'hextop';
    Y = pos';
    Y(:,2) = flipud(Y(:,2));
    
    
    % plot grid
    if plotit,
        z = sqrt(0.75)/3;
        shapex = [-1 0 1 1 0 -1]*0.5;
        shapey = [1 2 1 -1 -2 -1]*z;
        hold on;box on;
        for i=1:numNeurons
          fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor',[0.4 0.4 0.6],'EdgeColor',[1 1 1]*0.8);
        end    
        text(Y(:,1),Y(:,2),num2str([1:length(Y)]'),'VerticalAlignment','bottom','HorizontalAlignment','center');
    end
else
    kind = 'rectangular';
%     disp('rectangular grid');
    if length(recgridsize)==1
    	recgridsize = [recgridsize recgridsize];
    end
%     Y = meshgrid(1:recgridsize(1),1:recgridsize(2));
%     Y = [reshape(Y',1,prod(recgridsize))',reshape(Y,1,prod(recgridsize))'];
%     Y(:,2) = flipud(Y(:,2));
    Y = zeros(prod(recgridsize),2);
    actPos = 1;
    for i=recgridsize(1):-1:1
        Y(actPos:actPos+recgridsize(2)-1,:) = [[1:recgridsize(2)]',ones(recgridsize(2),1)*i];
        actPos = actPos+recgridsize(2);
    end
end
fprintf('constructed %s grid with %ix%i=%i positions\n',kind,recgridsize(1),recgridsize(2),size(Y,1));
end
%% plot hexgrid neighbor rings
%     Y = construct_grid(12);
%     positions = length(Y);
%     % and the grid neighbors
%     Ns = squaredEuclidean(Y);
%     [sortNs,sortNsIdx] =  sort(Ns);
%     sortNs = round(sortNs*10000)/10000;
%     gridDistances = unique(unique(sortNs(2:end,:)));    
%     useRings = 5;
%     RingDists = {[gridDistances(1)],[gridDistances(2),gridDistances(3)],[gridDistances(4),gridDistances(5)],...
%                  [gridDistances(6),gridDistances(8)],[gridDistances(9),gridDistances(11)]};
%     gridNeighbors = cell(positions,useRings);
%     for i=1:useRings
%         if i==1,
%             useGridNeighbors = RingDists{i};
%         else
%             useGridNeighbors = RingDists{i};
%         end
%         for actPos=1:positions
%             if i==1,
%                 targets = sortNsIdx(sortNs(:,actPos)<=useGridNeighbors,actPos);
%             else
%                 targets = sortNsIdx((sortNs(:,actPos)>=useGridNeighbors(1) & sortNs(:,actPos)<=useGridNeighbors(2)),actPos);
%             end            
%             gridNeighbors{actPos,i} = targets;
%         end
%     end
%     actPoint = 66;
%     hold on;axis off;
%     ylim([-0.8,max(Y(:,2))+0.8]);xlim([-0.8,max(Y(:,1))+0.8]);
%     for i=1:length(Y)
%         if intersect(gridNeighbors{i,1},actPoint)
%             fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','r','EdgeColor',[0.5,0.5,0.5]);
%         else
%             if intersect(gridNeighbors{i,2},actPoint)
%                 fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','b','EdgeColor',[0.5,0.5,0.5]);
%             else
%                 if intersect(gridNeighbors{i,3},actPoint)
%                     fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','g','EdgeColor',[0.5,0.5,0.5]);
%                 else
%                     if intersect(gridNeighbors{i,4},actPoint)
%                         fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','m','EdgeColor',[0.5,0.5,0.5]);
%                     else
%                         if intersect(gridNeighbors{i,5},actPoint)
%                             fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','y','EdgeColor',[0.5,0.5,0.5]);
%                         else
%                             fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','w','EdgeColor',[0.5,0.5,0.5]);
%                         end
%                     end
%                 end
%             end
%         end    
%     end 